-- *******************************************************************************
-- author.........: Reinhard Reisinger
-- copyright......: ritconsult IT und Projektconsulting Ges.m.b.H.
-- date written...: 2023.02.10
-- 
-- add all admin object for special formats - used in admin pages
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2023.02.10   rre     create this cool feature
--
-- *******************************************************************************
-- select * from et_format_domain_logical;
-- delete from et_format_domain_logical;
 insert into et_format_domain_logical (domain_id_logical, description, edittype, param_edittype, textarea_rows, textarea_cols) 
 values 
	('ZLD_checkbox10', 	 'checkbox','checkbox', '1:0', null, null),
	('ZLD_checkboxYN', 	 'checkbox','checkbox', 'Y:N', null, null),
	('ZLD_description',  'description ','text', '?', 1, 50),
	('ZLD_tinylock', 	 'tiny sized','textarea', '?', 2, 30),
	('ZLD_smallblock', 	 'small sized','textarea', '?', 4, 30),
	('ZLD_largeblock', 	 'large sized','textarea', '?', 6, 50),
	('ZLD_commandblock', 'command/string','textarea', '?', 4, 60),
	('ZLD_wideblock', 	 'wide sized','textarea', '?', 2, 60),
	('ZLD_mediumblock',	 'medium sized','textarea', '?', 5, 50)
 as loadval
 on DUPLICATE KEY UPDATE
	description = loadval.description,
	edittype = loadval.edittype,
	param_edittype = loadval.param_edittype,
	textarea_rows = loadval.textarea_rows,
	textarea_cols = loadval.textarea_cols
 ;
 
-- delete from et_format_domain_physical;
 insert into et_format_domain_physical (domain_id_physical, description, editsize, editmaxlength) 
 values 
-- A
	('ZPD_application', 	'Appliation Code',			5,5),
-- B
	('ZPD_bigNBR9', 		'Big Number',				9, 9),
	('ZPD_bigNBR11', 		'Big Number',				11, 11),
-- C
	('ZPD_catalogID', 		'Catalog ID',				9, 9),
	('ZPD_category', 		'Category',					32, 32),
	('ZPD_columname', 		'Column Name',				64, 64),
	('ZPD_columntitle', 	'Column Title',				64, 64),
	('ZPD_collection', 		'Collection',				32, 32),
	('ZPD_caption', 		'Caption',					64, 64),
	('ZPD_columnheading', 	'Column Heading',			512, 512),
	('ZPD_commandstring', 	'Commandstring',			512, 512),
	('ZPD_config', 			'Configuration ID',			16, 16),
	('ZPD_configValue',		'Configuration Value',		64, 64),
	('ZPD_constraint', 		'Constraint',				16, 16),
	('ZPD_callable', 		'Callable Object',			32, 32),
	('ZPD_checkbox', 		'Checkbox',					1, 1),
	('ZPD_connection', 		'Connection',				16, 16),
 -- D   
	('ZPD_date10', 			'Date',						10, 10),
	('ZPD_description', 	'Description',				30, 30),
	('ZPD_domain', 			'Domain ID',				50, 50),
	('ZPD_defaultvalue', 	'Default Value',			50, 50),
	('ZPD_digit', 			'Digit',					1, 1),
-- E    
	('ZPD_email', 			'eMail',					64, 64),
	('ZPD_edittype', 		'Edittype',					64, 64),
-- F    
	('ZPD_filename', 		'Filename',					64, 64),
-- G    
	('ZPD_GUID', 			'GUID',						32, 32),
-- H    
	('ZPD_humanname', 		'Human/Personal Name',		64, 64),
-- I    
	('ZPD_instance', 		'Instance Name',			16, 16),
	('ZPD_instanceKEY', 	'Catalog ID+Instance Name',	26, 26),
-- L    
	('ZPD_loglink', 		'Logical Link',				32, 32),
	('ZPD_label', 			'Label',					64, 64),
	('ZPD_language', 		'Language',					2, 2),
	('ZPD_lookup', 			'Lookup',					16, 16),
-- M    
	('ZPD_menu', 			'Menu',						10, 10),
	('ZPD_messageID', 		'Message ID',				9,	9),
	('ZPD_messagestring', 	'Message String',			256, 256),
-- O    
	('ZPD_objectname', 		'Object Name',				64, 64),
	('ZPD_ordinalNBR', 		'Ordinal Number',			3, 3),
	('ZPD_operandVAL', 		'Operand Value',			64, 64),
-- P    
	('ZPD_password', 		'Password',					32, 32),
	('ZPD_paramID', 		'Parameter ID',				32, 32),
	('ZPD_paramVAL', 		'Parmeter Value',			64, 64),
	('ZPD_paramlong', 		'Parameter long Value',		128, 128),
	('ZPD_phone', 			'Phone',					32, 32),
-- S    
	('ZPD_session',			'Session ID',				32, 32),
	('ZPD_smallNBR2', 		'Small Number',				2, 2),
	('ZPD_smallNBR3', 		'Small Number',				3, 3),
	('ZPD_smallNBR5', 		'Small Number',				5, 5),
	('ZPD_sortorder', 		'Sortorder',				3, 3), 
	('ZPD_sqlclause', 		'SQL Clause',				512, 512),
-- T    
	('ZPD_transaction', 	'Transaction',				16, 16),
	('ZPD_typeN', 			'Numeric Type', 			1, 1),
	('ZPD_typeNN', 			'Numeric Type',				2, 2),
	('ZPD_typeX', 			'Character Type',			1, 1),
	('ZPD_typeXXX', 		'Character Type',			3, 3),
-- U    
	('ZPD_userID', 			'User ID',					16, 16),	
	('ZPD_username', 		'User ID',					64, 64),
	('ZPD_UCAstring', 		'User Comm Area String',	512,512),
	('ZPD_usergroup', 		'Usergroup',				32, 32)
as loadval
on DUPLICATE KEY UPDATE
	description = loadval.description,
	editsize = loadval.editsize,
	editmaxlength = loadval.editmaxlength;
    
-- delete from et_format_domain_semantic;
 
 insert into et_format_domain_semantic (domain_id_semantic, description, column_title_ui, column_heading_ui, colvalue_default) 
 values 
-- switches
('ZSD_active', 			'active/inactive switch',	'activate',		 			'switch to toggle settings between active/inactive', null),
('ZSD_allow', 			'allow/deny switch',		'allow',		 			'switch to toggle settings between allow/deny to given group', null),
('ZSD_onoff', 			'on/off switch',			'on/off',		 			'switch to toggle settings between on/off', null),
('ZSD_onoffcustomer',	'on/off customer switch',	'on/off Customer Flag',		'switch to toggle customer settings between on/off', null),
('ZSD_use', 			'use/use not switch',		'use/ignore',				'switch to toggle settings between use/ignore', null),
('ZSD_useas', 			'use as indicator',			'use as',					'switch to toggle specifiy explicit usage of object as', null),
('ZSD_mark', 			'mark as indicator',		'mark as',					'switch to toggle mark', null),
-- A
('ZSD_application', 	'Application Code',			'Application',				'Code/Name of Application', null),
('ZSD_autosequence', 	'Autosequence',				'Internal ID of',			'Internal ID of', null),
('ZSD_autosort', 		'Autosort',					'Internal Sort ID',			'Internal ID to sort', null),
-- C
('ZSD_catalogID', 		'Catalog ID',				'Catalog ID',				'Catalog ID', null),
('ZSD_catalogInstance',	'Catalog ID + Instance',	'Catalog.Instance ID',		'Catalog Instance ID (dotted)', null),
('ZSD_categorystring',	'Categorystring',			'Category of',				'(Custom defined) Category of', null),
('ZSD_codeof',			'Code',						'Code of',					'Code of', null),
('ZSD_collection',		'Collection',		    	'Format Collection',		'Collection of format option', null),
('ZSD_commandstring',	'Command String',			'Command to',				'Commandstring to', null),
('ZSD_caption',			'Caption String',			'Caption',					'Captiontext', null),
('ZSD_columnlist',		'Columnlist',	    		'Columnlist',				'List of columns (separated by comma)', null),
('ZSD_columnname', 		'Columnname',				'Columnname',			    'Name of column', null),
('ZSD_collection',		'Collection',	    		'Collection',				'Collection', null),
('ZSD_callable', 		'Unique Callable object',	'Callable Object',			'Callable object', null),
('ZSD_constraint', 		'Unique Constraint name',	'Constraint',				'Constraint', null),
('ZSD_config', 		    'Unique Config ID',			'Name of Configuration',	'Configuration parameter name', null),
('ZSD_configvalue',     'Configuaration Value',		'Value of Configuration',	'Configuration parameter value', null),
('ZSD_connection', 		'Unique Connection Name',	'Connection',				'Connection', null),
('ZSD_connectiontype', 	'Type of Connection',		'Connectiontype',	    	'Connectiontype 0=database, 1=...', null),
-- D
('ZSD_description', 	'Description',				'Description',				'Description', null),
('ZSD_domain', 			'Domain ID ',				'Domain ID',				'Domain ID ', null),
('ZSD_dateof', 			'Date of sth.',				'Date of',					'Date of', null),
('ZSD_datatype', 		'Datatype of sth.',			'Datatype of',				'Datatype of', null),
('ZSD_defaultvalue', 	'Defaultvalue of sth.',		'Defaultvalue of',			'Defaultvalue of', null),
('ZSD_DBconnection', 	'Database Connection',		'DB Connection',			'Database connection', null),
-- E
('ZSD_edittype', 		'Edittype',					'Edittype',					'Edittype of', null),
('ZSD_editsize', 		'Edit Size',				'Edit Size',				'Edit size', null),
('ZSD_email', 			'EMail Address',			'Email Address',			'Full email address', null),
-- F
('ZSD_firstname', 		'Firstname',				'Firstname',				'Firstname', null),
('ZSD_lastname', 		'Lastname',					'Lastname',					'Lastname', null),
('ZSD_filename', 		'Full name of a file',		'File',						'Full name of file', null),
('ZSD_formposition', 	'Form Position Value',		'Formposition',				'Formposition', null),
-- G
('ZSD_gridlocation', 	'Gridlocation',				'Location of',				'Location number (0=left upper, 1, 2, 3=right lower) on grid', null),
('ZSD_GUID', 		    'GUID',						'GUID',						'Global Unique ID', null),
-- H
('ZSD_heading', 		'Mouse over Text',			'Heading of',				'Heading text of', null),
-- I
('ZSD_instance', 		'Instance Name',			'Instance',			    	'Name of catalog object instance', null),
('ZSD_iconfile', 		'Name of Iconfile',			'Iconfile',	    			'Full name of file on server', null),
-- L
('ZSD_language', 		'Language Code',			'Language Code',			'Language Code', null),
('ZSD_label', 		    'Label text',	    		'Label of',			        'Label of', null),
('ZSD_length', 			'Length',					'Length of',				'Length of', null),
('ZSD_level', 			'Level code',				'Level of',					'Level of', null),
('ZSD_loglink', 		'Logical Link',				'Logical Link',				'Logical link', null),
('ZSD_lookup', 			'Unique Lookup ID',			'Lookup',					'Lookup', null),
-- M
('ZSD_messageID', 		'Unique Message ID',		'Message ID',				'Message ID', null),
('ZSD_menu', 			'Unique Menue ID',			'Menu ID',					'Menu ID', null),
('ZSD_managedobject', 	'Mmanaged Object',			'Table or View',			'Name of Table or View (without any extension or schema)', null),
-- N
('ZSD_numeric', 		'Numveric Value',			'Numeric Value',			'Numveric Value', null),
-- O
('ZSD_ordinalpos', 		'Ordinal Position',			'Ordinal Position',			'Ordinal position', null),
-- P
('ZSD_password', 		'Password',					'Password',					'Password', null),
('ZSD_phone', 			'Phone',					'Phonenumber',				'Phonenumber', null),
-- S
('ZSD_session', 		'Session ID',				'Session ID',				'Session ID', null),
('ZSD_sqlclause', 		'SQLclause String',			'SQL',			 	        'SQL Syntax (part)', null),
('ZSD_sortorder', 		'Sortorder',				'Sortorder',				'Sortorder value ', null),
-- T
('ZSD_typeXXX', 		'Type',						'Type of',					'Type of', null),
('ZSD_typeN', 			'Type',						'Type of',					'Type of', null),
('ZSD_type', 			'Type',						'Type of',					'Type of', null),
('ZSD_text', 			'Text',						'Text of',					'Text of', null),
('ZSD_textfilter', 		'Textfilter',				'Filter Criteria',			'Filter criteria', null),
('ZSD_title', 			'Title',					'Title of',					'Title text of', null),
('ZSD_transaction', 	'Unique Transaction Name',	'Transaction Name',	    	'Name of transaction', null),
-- U
('ZSD_user', 			'Unique User ID ',			'User ID',	    			'User ID', null),
('ZSD_UCA', 			'UCA String',				'User Comm. Area',	 		'User Communicatio Area String', null),
('ZSD_usergroup', 		'Unique User Group ID ',	'User Group ID',	    	'User group ID', null)

 as loadval
 on DUPLICATE KEY UPDATE
	description = loadval.description,
	column_title_ui = loadval.column_title_ui,
	column_heading_ui = loadval.column_heading_ui,
	colvalue_default = loadval.colvalue_default
 ;
 
 
 --
 -- delete from et_catalog_object_column_prop where catalog_id <= -1;

call mdConfig_ColumnProperty('SETFORMAT','METADB(niota_meta)', 'et_callable_access');
call mdConfig_ColumnProperty('SETFORMAT','METADB(niota_meta)', 'et_callable_object');
call mdConfig_ColumnProperty('SETFORMAT','METADB(niota_meta)', 'et_callable_seq');
call mdConfig_ColumnProperty('SETFORMAT','METADB(niota_meta)', 'et_catalog_object');
call mdConfig_ColumnProperty('SETFORMAT','METADB(niota_meta)', 'et_catalog_object_access');
call mdConfig_ColumnProperty('SETFORMAT','METADB(niota_meta)', 'et_catalog_object_callable');
call mdConfig_ColumnProperty('SETFORMAT','METADB(niota_meta)', 'et_catalog_object_column_prop');
call mdConfig_ColumnProperty('SETFORMAT','METADB(niota_meta)', 'et_catalog_object_instance');
call mdConfig_ColumnProperty('SETFORMAT','METADB(niota_meta)', 'et_connection');
call mdConfig_ColumnProperty('SETFORMAT','METADB(niota_meta)', 'et_constraint');

call mdConfig_ColumnProperty('SETFORMAT','METADB(niota_meta)', 'et_format_collection_column');
call mdConfig_ColumnProperty('SETFORMAT','METADB(niota_meta)', 'et_format_domain_logical');
call mdConfig_ColumnProperty('SETFORMAT','METADB(niota_meta)', 'et_format_domain_physical');
call mdConfig_ColumnProperty('SETFORMAT','METADB(niota_meta)', 'et_format_domain_semantic');
call mdConfig_ColumnProperty('SETFORMAT','METADB(niota_meta)', 'et_format_object');
call mdConfig_ColumnProperty('SETFORMAT','METADB(niota_meta)', 'et_format_object_column');

call mdConfig_ColumnProperty('SETFORMAT','METADB(niota_meta)', 'et_logging');
call mdConfig_ColumnProperty('SETFORMAT','METADB(niota_meta)', 'et_lookup');
call mdConfig_ColumnProperty('SETFORMAT','METADB(niota_meta)', 'et_lookup_value_system');
call mdConfig_ColumnProperty('SETFORMAT','METADB(niota_meta)', 'et_metadb_object');
call mdConfig_ColumnProperty('SETFORMAT','METADB(niota_meta)', 'et_metadb_link');
call mdConfig_ColumnProperty('SETFORMAT','METADB(niota_meta)', 'et_metadb_link_detail');
call mdConfig_ColumnProperty('SETFORMAT','METADB(niota_meta)', 'et_table_link');
call mdConfig_ColumnProperty('SETFORMAT','METADB(niota_meta)', 'et_table_link_detail');
call mdConfig_ColumnProperty('SETFORMAT','METADB(niota_meta)', 'et_transaction');
call mdConfig_ColumnProperty('SETFORMAT','METADB(niota_meta)', 'et_transaction_access');
call mdConfig_ColumnProperty('SETFORMAT','METADB(niota_meta)', 'et_transaction_menu');
call mdConfig_ColumnProperty('SETFORMAT','METADB(niota_meta)', 'et_transaction_parameter_set');
call mdConfig_ColumnProperty('SETFORMAT','METADB(niota_meta)', 'et_user');
call mdConfig_ColumnProperty('SETFORMAT','METADB(niota_meta)', 'et_user_comm_area');
call mdConfig_ColumnProperty('SETFORMAT','METADB(niota_meta)', 'et_user_group');
call mdConfig_ColumnProperty('SETFORMAT','METADB(niota_meta)', 'et_user_group_member');
call mdConfig_ColumnProperty('SETFORMAT','METADB(niota_meta)', 'et_user_parameter');
call mdConfig_ColumnProperty('SETFORMAT','METADB(niota_meta)', 'etx_catalog_object_blob');
call mdConfig_ColumnProperty('SETFORMAT','METADB(niota_meta)', 'etx_catalog_object_config');
call mdConfig_ColumnProperty('SETFORMAT','METADB(niota_meta)', 'etx_log');
call mdConfig_ColumnProperty('SETFORMAT','METADB(niota_meta)', 'etx_message');
call mdConfig_ColumnProperty('SETFORMAT','METADB(niota_meta)', 'etx_message_detail');
call mdConfig_ColumnProperty('SETFORMAT','METADB(niota_meta)', 'etx_message_text');
call mdConfig_ColumnProperty('SETFORMAT','METADB(niota_meta)', 'etx_sequence');
call mdConfig_ColumnProperty('SETFORMAT','METADB(niota_meta)', 'etx_system_config');
call mdConfig_ColumnProperty('SETFORMAT','METADB(niota_meta)', 'etx_user_config');
call mdConfig_ColumnProperty('SETFORMAT','METADB(niota_meta)', 'etx_useraction');

--
-- add system meta db object to standard catalog
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2023.02.10   rre     create this cool feature
--
-- *******************************************************************************
 
 -- delete from et_catalog_object_instance where catalog_id < 0;
 -- delete from et_catalog_object where catalog_id < 0;
 
 insert into et_catalog_object (catalog_id, conn_name, object, description, date_activation, ind_active)
 select * from (
 select catalog_id, 'niota_meta' as conn_name, object, description, cast('2000-01-01' as date) as date_activation, 1 as ind_active
   from et_metadb_object
 ) loadval
 on DUPLICATE KEY UPDATE
	description = loadval.description,
	conn_name = loadval.conn_name, 
	object = loadval.object, 
	date_activation = loadval.date_activation, 
	ind_active = loadval.ind_active;
 
 delete from et_catalog_object_instance where catalog_id < 0 and instance_name not in ('*ADMIN');
 delete from et_catalog_object_instance where instance_name like '*ADMIN%' and catalog_id < 0;
 --
 --
-- 
-- select * from et_format_object;
-- add default settings for admin instances
-- delete from et_format_object where catalog_id = 0; 
 insert into et_format_object (catalog_id, instance_name, ind_active, pagesize, form_width, ind_rownumbers, ind_advanced_search, ind_multiselect) 
 values 
 (0, '*ADMIN',  1,-1,'600',1,0,0),
 (0, '*DEFAULT',1,20,'600',1,0,0)
 as loadval
 on DUPLICATE KEY UPDATE
   ind_active = loadval.ind_active,
   pagesize = loadval.pagesize,
   form_width = loadval.form_width,
   ind_rownumbers = loadval.ind_rownumbers,
   ind_advanced_search = loadval.ind_advanced_search,
   ind_multiselect = loadval.ind_multiselect
 ;
 
 --
 --
-- remove columns from standard format collection table
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2023.02.10   rre     niota core does not use format collections
--
-- *******************************************************************************

-- select * from et_format_collection_column;
--  delete from et_format_collection_column;

 
-- add all volatile columns for admin tables - used in admin pages
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2023.02.10   rre     create this cool feature
--
-- *******************************************************************************
-- delete from et_catalog_object_column_prop where catalog_id < 0 and ind_is_volatile = 1;
insert into et_catalog_object_column_prop  
(catalog_id, column_name, ind_active, ind_is_volatile, description, column_title_ui, column_heading_ui, domain_id_physical, domain_id_logical, domain_id_semantic)  

values
(mdLookup_SysMDObject('et_catalog_object'), 'sort_id', 1, 1,						'internal', null,null, 'ZPD_bigNBR11', null, 'ZSD_autosort'),
(mdLookup_SysMDObject('et_catalog_object_access'), 'catalog_instance_tmp', 1, 1, 	'internal', 'Lookup','', 'ZPD_instanceKEY', null, 'ZSD_cataloginstance'),
(mdLookup_SysMDObject('et_catalog_object_instance'), 'sort_id', 1, 1, 				'internal', '','', 'ZPD_bigNBR11', null, 'ZSD_autosort'),
(mdLookup_SysMDObject('et_lookup'), 'catalog_instance_tmp', 1, 1, 					'internal', 'Lookup','', 'ZPD_instanceKEY', null, 'ZSD_cataloginstance'),
(mdLookup_SysMDObject('et_table_link'), 'ciid_master_tmp', 1, 1, 					'internal', 'Master','', 'ZPD_instanceKEY', null, 'ZSD_cataloginstance'),
(mdLookup_SysMDObject('et_table_link'), 'ciid_detail_tmp', 1, 1, 					'internal', 'Detail','', 'ZPD_instanceKEY', null, 'ZSD_cataloginstance'),
(mdLookup_SysMDObject('et_table_link'), 'ciid_data_tmp', 1, 1, 						'internal', 'Data','', 'ZPD_instanceKEY', null, 'ZSD_cataloginstance'),
(mdLookup_SysMDObject('et_table_link'), 'ciid_filter_tmp', 1, 1, 					'internal', 'Filter','', 'ZPD_instanceKEY', null, 'ZSD_cataloginstance')
as loadval
on DUPLICATE KEY UPDATE
   description = loadval.description,
   ind_active = loadval.ind_active,
   ind_is_volatile = loadval.ind_is_volatile,
   domain_id_physical = loadval.domain_id_physical,
   domain_id_logical = loadval.domain_id_logical,
   domain_id_semantic = loadval.domain_id_semantic,
   column_title_ui = loadval.column_title_ui,
   column_heading_ui = loadval.column_heading_ui
 ;
 
--
--
-- add all admin object for special formats - used in admin pages
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2023.02.10   rre     create this cool feature
--
-- *******************************************************************************

-- delete from et_format_object where catalog_id < 0;
insert into et_format_object  (catalog_id, instance_name, ind_active, grid_caption_ui, grid_caption_suffix_ui, pagesize, form_width, ind_rownumbers, ind_advanced_search, ind_multiselect)  
values
(mdLookup_SysMDObject('et_callable_access'),		 		'*ADMIN_EDIT_MDD', 	 	1, null, 'edit detail', 	null, null, null, null, null),
--
(mdLookup_SysMDObject('et_callable_object'),	 			'*ADMIN_EDIT_MDM',		1, null, 'edit', 			10, '1200', null, 1, null),
(mdLookup_SysMDObject('et_callable_object'),	 			'*ADMIN_LIST',			1, null, 'list', 			10, '1200', null, 1, null),
--
(mdLookup_SysMDObject('et_callable_seq'),	 				'*ADMIN_EDIT_MDD',		1, null, 'edit detail', 	10, '1200', null, 1, null),
--
(mdLookup_SysMDObject('et_catalog_object'),	 				'*ADMIN_EDIT', 			1, null, 'edit', 	10, '1200', null, 1, null),
(mdLookup_SysMDObject('et_catalog_object'),	 				'*ADMIN_EDIT', 		 	1, null, 'edit', 	10, '1200', null, 1, null),
(mdLookup_SysMDObject('et_catalog_object'), 				'*ADMIN_LIST', 		 	1, null, 'list'	, 10, '900', null, 1, null),
(mdLookup_SysMDObject('et_catalog_object'), 				'*ADMIN_EDIT_ADD', 	 	1, null, 'add only', 10, '900', null, 1, null),
(mdLookup_SysMDObject('et_catalog_object'), 				'*ADMIN_EDIT_ADD2', 	1, null, 'add only - manual override', 10, '900', null, 1, null),
--
(mdLookup_SysMDObject('et_catalog_object_access'), 			'*ADMIN_EDIT_MDD', 	 	1, null, 'edit', 	null, null, null, null, null),
(mdLookup_SysMDObject('et_catalog_object_access'), 			'*ADMIN_LIST_MDD',		1, null, 'list', 	null, null, null, null, null),
--
(mdLookup_SysMDObject('et_catalog_object_callable'), 		'*ADMIN_EDIT_MDD', 	 	1, null, 'edit', 	null, null, null, null, null),
--
(mdLookup_SysMDObject('et_catalog_object_column_prop'), 	'*ADMIN_EDIT_MDD',   	1, null, 'edit', 	null, '1100', null, null, null),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), 	'*ADMIN_EDIT_MDD2',   	1, null, 'edit - UI properties ', 	null, '1100', null, null, null),
--
(mdLookup_SysMDObject('et_catalog_object_instance'),		'*ADMIN_LIST', 			1, null, 'list', 	null, null, null, null, null),
(mdLookup_SysMDObject('et_catalog_object_instance'), 		'*ADMIN_EDIT_MDD', 		1, null, 'edit detail', 	null, '1100', null, null, null),
--
(mdLookup_SysMDObject('et_connection'),		 				'*ADMIN_EDIT',		 	1, null, 'edit', 	null, null, null, null, null),
--
(mdLookup_SysMDObject('et_constraint'),		 				'*ADMIN_EDIT',		 	1, null, 'edit', 	null, null, null, null, null),
--
(mdLookup_SysMDObject('et_format_collection_column'), 		'*ADMIN_EDIT', 			1, null, 'edit', 	null, null, null, null, null),
--
(mdLookup_SysMDObject('et_format_domain_logical'), 			'*ADMIN_EDIT', 			1, null, 'edit', 	null, null, null, null, null),
--
(mdLookup_SysMDObject('et_format_domain_physical'), 		'*ADMIN_EDIT', 			1, null, 'edit', 	null, null, null, null, null),
--
(mdLookup_SysMDObject('et_format_domain_semantic'), 		'*ADMIN_EDIT', 			1, null, 'edit', 	null, null, null, null, null),
--
(mdLookup_SysMDObject('et_format_object'), 					'*ADMIN_EDIT_MDD', 		1, null, 'edit', 	null, null, null, null, null),
--
(mdLookup_SysMDObject('et_format_object_column'), 			'*ADMIN_EDIT_MDD', 		1, null, 'edit', 	null, null, null, null, null),
--
(mdLookup_SysMDObject('et_logging'),			 			'*ADMIN_EDIT', 			1, null, 'edit', 	10, '600', null, null, null),
--
(mdLookup_SysMDObject('et_lookup'),			 				'*ADMIN_EDIT', 			1, null, 'edit', 	10, '600', null, null, null),
--
(mdLookup_SysMDObject('et_metadb_object'),					'*ADMIN_EDIT', 			1, null, 'edit', 	10, '600', null, null, null),
--
(mdLookup_SysMDObject('et_table_link'), 					'*ADMIN_EDIT_MDM2',		1, null, 'master detail - master config', null, null, null, null, null),
(mdLookup_SysMDObject('et_table_link'), 					'*ADMIN_EDIT_MDM3', 	1, null, 'advanced filter - data config', null, null, null, null, null),
--
(mdLookup_SysMDObject('et_table_link_detail'), 				'*ADMIN_EDIT_MDD2', 	1, null, 'master detail - detail config', null, null, null, null, null),
(mdLookup_SysMDObject('et_table_link_detail'), 				'*ADMIN_EDIT_MDD3', 	1, null, 'advanced filter - filtered by config', null, null, null, null, null),
--
(mdLookup_SysMDObject('et_transaction'), 					'*ADMIN_EDIT_MDM', 		1, null, 'edit', null, null, null, null, null),
(mdLookup_SysMDObject('et_transaction'), 					'*ADMIN_LIST', 			1, null, 'list', null, null, null, null, null),
--
(mdLookup_SysMDObject('et_transaction_access'), 			'*ADMIN_EDIT_MDD', 		1, null, 'edit', null, null, null, null, null),
--
(mdLookup_SysMDObject('et_transaction_parameter_set'),		'*ADMIN_EDIT_MDD', 		1, null, 'edit', null, '900', null, 1, null),
--
(mdLookup_SysMDObject('et_transaction_menu'), 				'*ADMIN_EDIT_MDM2', 	1, null, 'node items', null, '900', null, 1, null),
(mdLookup_SysMDObject('et_transaction_menu'), 				'*ADMIN_EDIT_MDD2', 	1, null, 'leaf items', null, '900', null, 1, null),
--
(mdLookup_SysMDObject('et_user'), 							'*ADMIN_EDIT', 			1, null, 'edit', null, null, null, null, null),
(mdLookup_SysMDObject('et_user'), 							'*ADMIN_LIST', 			1, null, 'list', null, null, null, null, null),
--
(mdLookup_SysMDObject('et_user_comm_area'), 				'*ADMIN_EDIT', 			1, null, 'edit', null, null, null, null, null),
--
(mdLookup_SysMDObject('et_user_group'), 					'*ADMIN_EDIT', 			1, null, 'edit', null, null, null, null, null),
(mdLookup_SysMDObject('et_user_group'), 					'*ADMIN_LIST', 			1, null, 'list', null, null, null, null, null),
--
(mdLookup_SysMDObject('et_user_group_member'), 				'*ADMIN_EDIT_MDD', 		1, null, 'edit details', null, null, null, null, null),
--
(mdLookup_SysMDObject('et_transaction_menu'), 				'*ADMIN_EDIT_MDD2', 	1, null, 'nodes', null, '900', null, 1, null),
--
(mdLookup_SysMDObject('etx_message_text'), 					'*ADMIN_EDIT', 			1, null, 'edit', null, null, null, null, null),
(mdLookup_SysMDObject('etx_message_text'), 					'*ADMIN_EDIT_CUST', 	1, null, 'edit customer text', null, null, null, null, null),
--
(mdLookup_SysMDObject('etx_sequence'), 						'*ADMIN_EDIT', 			1, null, 'edit', null, null, null, null, null),
(mdLookup_SysMDObject('etx_sequence'), 						'*ADMIN_EDIT_CUST', 	1, null, 'edit customer sequence', null, null, null, null, null),
--
(mdLookup_SysMDObject('etx_user_config'), 					'*ADMIN_EDIT', 			1, null, 'edit', null, null, null, null, null),
(mdLookup_SysMDObject('etx_user_config'), 					'*ADMIN_EDIT_CUST', 	1, null, 'edit customer config', null, null, null, null, null),
--
(mdLookup_SysMDObject('etx_system_config'), 				'*ADMIN_EDIT', 			1, null, 'edit', null, null, null, null, null),
(mdLookup_SysMDObject('etx_system_config'), 				'*ADMIN_EDIT_CUST',		1, null, 'edit customer config', null, null, null, null, null),
--
(mdLookup_SysMDObject('etx_catalog_object_config'), 		'*ADMIN_EDIT_MDD', 		1, null, 'edit', null, null, null, null, null)
as loadval
on DUPLICATE KEY UPDATE
   ind_active = loadval.ind_active,
   grid_caption_ui = loadval.grid_caption_ui,
   pagesize = loadval.pagesize,
   form_width = loadval.form_width,
   ind_rownumbers = loadval.ind_rownumbers,
   ind_advanced_search = loadval.ind_advanced_search,
   ind_multiselect = loadval.ind_multiselect
 ;
 
 -- add all admin object for special formats - used in admin pages
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2023.02.10   rre     create this cool feature
--
-- *******************************************************************************

--
-- select * from et_format_object_column where catalog_id = -1016
-- delete from et_format_object_column where catalog_id < 0;
insert into et_format_object_column  
(catalog_id, instance_name, column_name, column_title_ui, column_heading_ui, ind_is_required, ind_is_read_only, ind_is_hidden, ind_editable_hidden, colvalue_default)  
values
(mdLookup_SysMDObject('et_catalog_object_access'), 		'*ADMIN_EDIT_MDD', 		'catalog_id', null, null, null, 1, 1, 1, null), 
(mdLookup_SysMDObject('et_catalog_object_access'), 		'*ADMIN_EDIT_MDD', 		'instance_name', null, null, null, 1, 1, 1, null), 

(mdLookup_SysMDObject('et_catalog_object_access'), 		'*ADMIN_EDIT_MDD', 		'instance_name', null, null, null, 1, 1, 1, null), 

(mdLookup_SysMDObject('et_transaction_access'), 		'*ADMIN_EDIT_MDD', 		'transaction_code', null, null, null, 1, 1, 1, null), 

(mdLookup_SysMDObject('et_format_object'), 				'*ADMIN_EDIT_MDD', 		'catalog_id', null, null, null, 1, 1, 1, null), 
(mdLookup_SysMDObject('et_format_object'), 				'*ADMIN_EDIT_MDD', 		'instance_name', null, null, null, 1, 1, 1, null), 

(mdLookup_SysMDObject('et_format_object_column'), 		'*ADMIN_EDIT_MDD', 		'catalog_id', null, null, null, 1, 1, 1, null), 
(mdLookup_SysMDObject('et_format_object_column'), 		'*ADMIN_EDIT_MDD', 		'instance_name', null, null, null, 1, 1, 1, null),

(mdLookup_SysMDObject('et_table_link'), 				'*ADMIN_EDIT_MDM2', 	'catalog_id_master', null, null, 0, null, 1, 0, null), 
(mdLookup_SysMDObject('et_table_link'), 				'*ADMIN_EDIT_MDM2', 	'instance_name_master', null, null, 0, null, 1, 0, null),
(mdLookup_SysMDObject('et_table_link'), 				'*ADMIN_EDIT_MDM2', 	'catalog_id_detail', null, null, 0, null, 1, 0, null), 
(mdLookup_SysMDObject('et_table_link'), 				'*ADMIN_EDIT_MDM2', 	'instance_name_detail', null, null, 0, null, 1, 0, null),
(mdLookup_SysMDObject('et_table_link'), 				'*ADMIN_EDIT_MDM2', 	'ciid_master_tmp', null, null, 1, null, null, null, null),
(mdLookup_SysMDObject('et_table_link'), 				'*ADMIN_EDIT_MDM2', 	'ciid_detail_tmp', null, null, 1, null, null, null, null),

(mdLookup_SysMDObject('et_table_link'), 				'*ADMIN_EDIT_MDM3', 	'catalog_id_master', null, null, 0, null, 1, 0, null), 
(mdLookup_SysMDObject('et_table_link'), 				'*ADMIN_EDIT_MDM3', 	'instance_name_master', null, null, 0, null, 1, 0, null),
(mdLookup_SysMDObject('et_table_link'), 				'*ADMIN_EDIT_MDM3', 	'logical_link', 'Data-Filter', null, null, null, null, null, null),
(mdLookup_SysMDObject('et_table_link'), 				'*ADMIN_EDIT_MDM3', 	'catalog_id_detail', null, null, 0, null, 1, 0, null), 
(mdLookup_SysMDObject('et_table_link'), 				'*ADMIN_EDIT_MDM3', 	'instance_name_detail', null, null, 0, null, 1, 0, null),
(mdLookup_SysMDObject('et_table_link'), 				'*ADMIN_EDIT_MDM3', 	'ciid_data_tmp', null, null, 1, null, null, null, null),
(mdLookup_SysMDObject('et_table_link'), 				'*ADMIN_EDIT_MDM3', 	'ciid_filter_tmp', null, null, 1, null, null, null, null),
(mdLookup_SysMDObject('et_table_link'), 				'*ADMIN_EDIT_MDM3', 	'icon_link', 'advanced Filter', null, null, null, null, null, null),

(mdLookup_SysMDObject('et_table_link_detail'), 			'*ADMIN_EDIT_MDD2', 	'catalog_id_master', null, null, 1, 1, 1, 1, null), 
(mdLookup_SysMDObject('et_table_link_detail'), 			'*ADMIN_EDIT_MDD2', 	'instance_name_master', null, null, 1, 1, 1, 1, null),
(mdLookup_SysMDObject('et_table_link_detail'), 			'*ADMIN_EDIT_MDD2', 	'logical_link', null, null, 1, 1, 1, 1, null),
(mdLookup_SysMDObject('et_table_link_detail'), 			'*ADMIN_EDIT_MDD2', 	'column_name_master', 'from Master Table', null, null, null, null, null, null),
(mdLookup_SysMDObject('et_table_link_detail'), 			'*ADMIN_EDIT_MDD2', 	'column_name_detail', 'in Detail Table', null, null, null, null, null, null),

(mdLookup_SysMDObject('et_table_link_detail'), 			'*ADMIN_EDIT_MDD3', 	'catalog_id_master', null, null, 1, 1, 1, 1, null), 
(mdLookup_SysMDObject('et_table_link_detail'), 			'*ADMIN_EDIT_MDD3', 	'instance_name_master', null, null, 1, 1, 1, 1, null),
(mdLookup_SysMDObject('et_table_link_detail'), 			'*ADMIN_EDIT_MDD3', 	'logical_link', null, null, 1, 1, 1, 1, null),
(mdLookup_SysMDObject('et_table_link_detail'), 			'*ADMIN_EDIT_MDD3', 	'column_name_master', 'from Data Table', null, null, null, null, null, null),
(mdLookup_SysMDObject('et_table_link_detail'), 			'*ADMIN_EDIT_MDD3', 	'column_name_detail', 'in Filter Table', null, null, null, null, null, null),

(mdLookup_SysMDObject('et_transaction_menu'), 			'*ADMIN_EDIT_MDM2', 	'transaction_code', null, null, null, 1, 1, null, null),
(mdLookup_SysMDObject('et_transaction_menu'), 			'*ADMIN_EDIT_MDD2', 	'menu_id', 'Leaf', 'of leaf menu item', null, null, null, null, null),
(mdLookup_SysMDObject('et_transaction_menu'), 			'*ADMIN_EDIT_MDD2', 	'menu_id_parent', null, null, 1, 1, 1, 1, null),

(mdLookup_SysMDObject('et_catalog_object_column_prop'), '*ADMIN_EDIT_MDD', 		'catalog_id', null, null, null, 1, 1, 1, null), 
(mdLookup_SysMDObject('et_catalog_object_column_prop'), '*ADMIN_EDIT_MDD', 		'column_name', null, null, null, 1, null, null, null), 
(mdLookup_SysMDObject('et_catalog_object_column_prop'), '*ADMIN_EDIT_MDD', 		'description', null, null, null, null, 1, 1, null),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), '*ADMIN_EDIT_MDD', 		'ind_lookup_import_check', null, null, null, null, 1, 1, null),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), '*ADMIN_EDIT_MDD', 		'ind_constraint_import_check', null, null, null, null, 1, 1, null),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), '*ADMIN_EDIT_MDD', 		'ordinal_position_pkey', null, null, null, null, 1, 1, null),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), '*ADMIN_EDIT_MDD', 		'lookup_name_extended', null, null, null, null, 1, 1, null),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), '*ADMIN_EDIT_MDD', 		'column_name_extended_lookup', null, null, null, null, 1, 1, null),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), '*ADMIN_EDIT_MDD', 		'ind_use_extended_lookup', null, null, null, null, 1, 1, null),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), '*ADMIN_EDIT_MDD', 		'ind_add_null', null, null, null, null, 1, 1, null),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), '*ADMIN_EDIT_MDD', 		'datatype', null, null, null, 1, 1, 1, null),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), '*ADMIN_EDIT_MDD', 		'metatype', null, null, null, 1, 1, 1, null),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), '*ADMIN_EDIT_MDD', 		'ind_nullable', null, null, null, 1, 1, 1, null),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), '*ADMIN_EDIT_MDD', 		'column_len', null, null, null, 1, 1, 1, null),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), '*ADMIN_EDIT_MDD', 		'ind_is_autoseq', null, null, null, 1, 1, 1, null),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), '*ADMIN_EDIT_MDD', 		'ind_is_volatile', null, null, null, null, 1, 1, null),
--
(mdLookup_SysMDObject('et_catalog_object_column_prop'), '*ADMIN_EDIT_MDD2', 	'catalog_id', null, null, null, 1, null, null, null), 
(mdLookup_SysMDObject('et_catalog_object_column_prop'), '*ADMIN_EDIT_MDD2', 	'column_name', null, null, null, 1, null, null, null), 
(mdLookup_SysMDObject('et_catalog_object_column_prop'), '*ADMIN_EDIT_MDD2', 	'description', null, null, null, 1, null, null, null), 
(mdLookup_SysMDObject('et_catalog_object_column_prop'), '*ADMIN_EDIT_MDD2', 	'ind_active', null, null, null, 1, null, null, null), 

(mdLookup_SysMDObject('et_catalog_object_column_prop'), '*ADMIN_EDIT_MDD2', 	'ind_is_required', null, null, null, null, 1, 1, null),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), '*ADMIN_EDIT_MDD2', 	'ind_is_read_only', null, null, null, null, 1, 1, null),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), '*ADMIN_EDIT_MDD2', 	'ind_hidden', null, null, null, null, 1, 1, null),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), '*ADMIN_EDIT_MDD2', 	'ind_editable_hidden', null, null, null, null, 1, 1, null),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), '*ADMIN_EDIT_MDD2', 	'colvalue_default', null, null, null, null, 1, 1, null),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), '*ADMIN_EDIT_MDD2', 	'domain_id_physical', null, null, null, null, 1, 1, null),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), '*ADMIN_EDIT_MDD2', 	'domain_id_logical', null, null, null, null, 1, 1, null),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), '*ADMIN_EDIT_MDD2', 	'domain_id_semantic', null, null, null, null, 1, 1, null),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), '*ADMIN_EDIT_MDD2', 	'column_title_ui', null, null, null, null, 1, 1, null),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), '*ADMIN_EDIT_MDD2', 	'column_heading_ui', null, null, null, null, 1, 1, null),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), '*ADMIN_EDIT_MDD2', 	'colpos_form', null, null, null, null, 1, 1, null),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), '*ADMIN_EDIT_MDD2', 	'rowpos_form', null, null, null, null, 1, 1, null),
--
(mdLookup_SysMDObject('et_catalog_object_instance'), 	'*ADMIN_LIST', 			'sort_id', null, null, null, 1, 1, 1, null), 
(mdLookup_SysMDObject('et_catalog_object_instance'), 	'*ADMIN_EDIT_MDD', 		'catalog_id', null, null, null, 1, 1, 1, null), 
(mdLookup_SysMDObject('etx_catalog_object_config'), 	'*ADMIN_EDIT_MDD', 		'catalog_id', null, null, null, 1, 1, 1, null),  
-- 
(mdLookup_SysMDObject('et_catalog_object'), 			'*ADMIN_LIST', 			'catalog_id', null, null, null, 1, null, 1, null),
(mdLookup_SysMDObject('et_catalog_object'), 			'*ADMIN_LIST', 			'sort_id', null, null, null, 1, 1, 1, null),

(mdLookup_SysMDObject('et_transaction_parameter_set'), 	'*ADMIN_EDIT_MDD', 		'transaction_code', null, null, null, 1, 1, 1, null),
(mdLookup_SysMDObject('et_transaction_parameter_set'), 	'*ADMIN_EDIT_MDD', 		'param_set', null, null, null, 1, 1, 1, null),

(mdLookup_SysMDObject('etx_message_text'), 				'*ADMIN_EDIT', 			'appcode_msg', null, null, null, 1, null, null, null),
(mdLookup_SysMDObject('etx_message_text'), 				'*ADMIN_EDIT', 			'msg_id', null, null, null, 1, null, null, null),
(mdLookup_SysMDObject('etx_message_text'), 				'*ADMIN_EDIT', 			'lang_msg', null, null, null, 1, null, null, null),

(mdLookup_SysMDObject('etx_sequence'), 					'*ADMIN_EDIT', 			'appcode_seq', null, null, null, 1, null, null, null),
(mdLookup_SysMDObject('etx_sequence'), 					'*ADMIN_EDIT', 			'seq_id', null, null, null, 1, null, null, null),

(mdLookup_SysMDObject('etx_system_config'), 			'*ADMIN_EDIT', 			'appcode_cfg', null, null, null, 1, null, null, null),
(mdLookup_SysMDObject('etx_system_config'), 			'*ADMIN_EDIT', 			'cfg_id', null, null, null, 1, null, null, null)
   
as loadval
on DUPLICATE KEY UPDATE
   ind_is_required = loadval.ind_is_required,
   ind_is_read_only = loadval.ind_is_read_only,
   ind_is_hidden = loadval.ind_is_hidden,
   column_title_ui = loadval.column_title_ui,
   ind_editable_hidden = loadval.ind_editable_hidden,
   colvalue_default = loadval.colvalue_default,
   column_title_ui = loadval.column_title_ui,
   column_heading_ui = loadval.column_heading_ui
 ;
 
 --
 -- delete from et_catalog_object_column_prop where catalog_id < 0;
 insert into et_catalog_object_column_prop  (catalog_id, column_name, column_title_ui, column_heading_ui, domain_id_physical, domain_id_logical, domain_id_semantic)
values
-- 
(mdLookup_SysMDObject('et_callable_access'), 'callable_object',null,'on which access should be granted','ZPD_callable',null,'ZSD_callable'),
(mdLookup_SysMDObject('et_callable_access'),'usergroupname',null,'to which access to callable object is granted','ZPD_usergroup',null,'ZSD_usergroup'),
(mdLookup_SysMDObject('et_callable_access'),'ind_active',null,'access of this object for this group', 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_active'),
--
(mdLookup_SysMDObject('et_callable_object'),'callable_object',null,'a configuration entry that wraps a callable command which can be called by niota.','ZPD_callable',null,'ZSD_callable'),
(mdLookup_SysMDObject('et_callable_object'),'description','Callable','of the callable object (command, webservice, ...). Used for lookup','ZPD_description', 'ZLD_description', 'ZSD_description'),
(mdLookup_SysMDObject('et_callable_object'),'ind_active',null,null,'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_active'),
(mdLookup_SysMDObject('et_callable_object'),'callobject_type','Callable','of the callable object - SQL command, stored procedure, script, ...','ZPD_typeN',null,'ZSD_type'),
(mdLookup_SysMDObject('et_callable_object'),'conn_name',null,'where callable object is located','ZPD_connection', null, 'ZSD_connection'),
(mdLookup_SysMDObject('et_callable_object'),'command','Callable','run this artefact. Previous to execution there is a parameter substitution. See: conf\callable_substitutions_help.txt','ZPD_commandstring','ZLD_largeblock','ZSD_commandstring'),
(mdLookup_SysMDObject('et_callable_object'),'callobject_category','Callable','of the callable object - Optional grouping of callable objects which belongs together logical','ZPD_categorystring',null,'ZSD_categorystring'),
(mdLookup_SysMDObject('et_callable_object'),'sortorder','Display','of the callable object when displayed on screen. The order is within an assignment to a catalog object','ZPD_sortorder',null,'ZSD_sortorder'),
(mdLookup_SysMDObject('et_callable_object'),'ind_messaging','Messages','check to read message table after execution of object','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoff'),
(mdLookup_SysMDObject('et_callable_object'),'ind_reload_grid','Table refresh','check to reload table table after execution of object','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoff'),
(mdLookup_SysMDObject('et_callable_object'),'ind_seq','is sequence','Is it a sequence or a single callable object','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoff'),
(mdLookup_SysMDObject('et_callable_object'),'promptpage_type','Prompt','page / .php page that is called to prompt user input before executable is called','ZPD_typeN',null,'ZSD_type'),
(mdLookup_SysMDObject('et_callable_object'),'icon_callable','Callable','file to be displayed on the user frontende','ZPD_filename',null,'ZSD_iconfile'),
(mdLookup_SysMDObject('et_callable_object'),'ind_use_uca','use UCA','activation of user cummunication area between niota and callable object','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoff'),
(mdLookup_SysMDObject('et_callable_object'),'ind_save_uca','save UCA','save user comm. area after call','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoff'),
(mdLookup_SysMDObject('et_callable_object'),'uca','Callable Object','to pass values between backend program and user frontend','ZPD_ucastring','ZLD_largeblock','ZSD_uca'),
--
(mdLookup_SysMDObject('et_callable_seq'),'callable_object','Main Object','The first item of the sequence. A callable object with &apos;is sequence&apos; indicator','ZPD_callable',null,'ZSD_callable'),
(mdLookup_SysMDObject('et_callable_seq'),'callable_object_seq_member','Sequence Member','from &apos;callable objects&apos; table.','ZPD_callable',null,'ZSD_callable'),
(mdLookup_SysMDObject('et_callable_seq'),'sort_order','Execute','of the callable object in the sequence.','ZPD_sortorder',null,'ZSD_sortorder'),
(mdLookup_SysMDObject('et_callable_seq'),'ind_active',null,null,'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_active'),
--
(mdLookup_SysMDObject('et_catalog_object'),'catalog_id',null,'is the unique number in niota for the managed database object','ZPD_catalogID',null,'ZSD_catalogID'),
(mdLookup_SysMDObject('et_catalog_object'),'conn_name',null,'where object is located','ZPD_connection',null,'ZSD_connection'),
(mdLookup_SysMDObject('et_catalog_object'),'object',null,'that is managed with niota','ZPD_objectname','ZLD_tinyblock','ZSD_managedobject'),
(mdLookup_SysMDObject('et_catalog_object'),'description','Object','of the catalog object (table, view). Used for lookup','ZPD_description', 'ZLD_description', 'ZSD_description'),
(mdLookup_SysMDObject('et_catalog_object'),'date_activation','Activation','activation of this configuration (logically)',null,null,'ZSD_dateof'),
(mdLookup_SysMDObject('et_catalog_object'),'ind_active',null,'activate this configuration','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_active'),
(mdLookup_SysMDObject('et_catalog_object'),'objectcategory','Object','to group objects on own demand. Can be used in quick access drop down box','ZPD_categorystring',null,'ZSD_categorystring'),
(mdLookup_SysMDObject('et_catalog_object'),'format_file_prefix','File or Database','to format object very generic based on column name only','ZPD_collection',null,'ZSD_collection'),
(mdLookup_SysMDObject('et_catalog_object'),'username_owner','Owner','that is responsible for content of this object. Data owner','ZPD_userID',null,'ZSD_User'),
(mdLookup_SysMDObject('et_catalog_object'),'usergroupname_deputy','Owner Deputy','that acts as deputy for data owner. Will be informed via major changes.','ZPD_usergroup',null,'ZSD_usergroup'),
(mdLookup_SysMDObject('et_catalog_object'),'ind_nolog_upload','suppress upload log','to suppress logging in case of upload (usefull for large tables)','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_active'),
(mdLookup_SysMDObject('et_catalog_object'),'ind_cust_01','01','- #01 - free to use','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoffcustomer'),
(mdLookup_SysMDObject('et_catalog_object'),'ind_cust_02','02','- #02 - free to use','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoffcustomer'),
(mdLookup_SysMDObject('et_catalog_object'),'ind_cust_03','03','- #03 - free to use','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoffcustomer'),
(mdLookup_SysMDObject('et_catalog_object'),'ind_cust_04','04','- #04 - free to use','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoffcustomer'),
(mdLookup_SysMDObject('et_catalog_object'),'ind_cust_05','05','- #05 - free to use','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoffcustomer'),
(mdLookup_SysMDObject('et_catalog_object'),'ind_cust_06','06','- #06 - free to use','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoffcustomer'),
(mdLookup_SysMDObject('et_catalog_object'),'ind_cust_07','07','- #07 - free to use','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoffcustomer'),
(mdLookup_SysMDObject('et_catalog_object'),'ind_cust_08','08','- #08 - free to use','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoffcustomer'),
(mdLookup_SysMDObject('et_catalog_object'),'ind_cust_09','09','- #09 - free to use','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoffcustomer'),
(mdLookup_SysMDObject('et_catalog_object'),'ind_cust_10','10','- #10 - free to use','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoffcustomer'),
--
(mdLookup_SysMDObject('et_catalog_object_access'),'usergroupname','Access','to which the access rights are granted to','ZPD_usergroup',null,'ZSD_usergroup'),
(mdLookup_SysMDObject('et_catalog_object_access'),'catalog_id',null,'on which access rights are granted','ZPD_catalogID',null,'ZSD_catalogID'),
(mdLookup_SysMDObject('et_catalog_object_access'),'instance_name',null,'on which access rights are granted','ZPD_instance', null, 'ZSD_instance'),
(mdLookup_SysMDObject('et_catalog_object_access'),'ind_active',null,null, 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_active'),
(mdLookup_SysMDObject('et_catalog_object_access'),'ind_allow_ins','add','insert new rows allowed for usergroup', 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_allow'),
(mdLookup_SysMDObject('et_catalog_object_access'),'ind_allow_upd','edit','edit rows allowed for usergroup', 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_allow'),
(mdLookup_SysMDObject('et_catalog_object_access'),'ind_allow_del','delete','delete allowed for usergroup', 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_allow'),
(mdLookup_SysMDObject('et_catalog_object_access'),'ind_allow_import','import','import via EXCEL allowed for usergroup', 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_allow'),
(mdLookup_SysMDObject('et_catalog_object_access'),'ind_allow_export','export','export to EXCEL allowed for usergroup', 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_allow'),
(mdLookup_SysMDObject('et_catalog_object_access'),'ind_allow_upd_partial','partial update','inactive', 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_allow'),
(mdLookup_SysMDObject('et_catalog_object_access'),'ind_allow_upload_partial','partial import','partial import via EXCEL allowed for usergroup', 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_allow'),
(mdLookup_SysMDObject('et_catalog_object_access'),'ind_hidden','hidden','hidden property in quick access drop down', 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_active'),
--
(mdLookup_SysMDObject('et_catalog_object_callable'),'catalog_id',null,'to which a callable object is assigned','ZPD_catalogID',null,'ZSD_catalogID'),
(mdLookup_SysMDObject('et_catalog_object_callable'),'callable_object',null,'that is assigned to the catalog object','ZPD_callable',null,'ZSD_callable'),
(mdLookup_SysMDObject('et_catalog_object_callable'),'description','Callable Object','for assignment','ZPD_description','ZLD_description', 'ZSD_description'),
(mdLookup_SysMDObject('et_catalog_object_callable'),'ind_active',null,'binding','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_active'),
(mdLookup_SysMDObject('et_catalog_object_callable'),'binding_level','Binding','Binding  On which level is the callable object bind to catalog object (table/vies). Row/Record-level, Table-level','ZPD_typeN',null,'ZSD_level'),
--
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'catalog_id',null,'Catalog Object ID where the configured column properties will apply','ZPD_catalogID',null,'ZSD_catalogID'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'column_name',null,'on which properties are configured','ZPD_columnname',null,'ZSD_columnname'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'description','Column','of this column','ZPD_description','ZLD_description', 'ZSD_description'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'ind_active',null,'column properties','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_active'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'lookup_name','for Column','configuration which will be applied to this column','ZPD_lookup',null,'ZSD_lookup'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'ind_lookup_import_check','Lookup at import','apply lookup checks on import via EXCEL','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_active'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'constraint_name','for Column','configuration which will be applied to this column','ZPD_constraintID',null,'ZSD_constraint'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'ind_constraint_import_check','Constraint at import','apply constraints on import via EXCEL','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_active'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'ordinal_position_pkey','in primary key','of this column in the (logical) primary key of the object. MUST be set on views','ZPD_ordinalNBR',null,'ZSD_ordinalpos'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'lookup_name_extended','extended','configuration in case of cascading lookup','ZPD_lookup',null,'ZSD_lookup'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'column_name_extended_lookup','Filter extended','that filters the relationship table for extended lookup','ZPD_columnname',null,'ZPD_columnname'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'ind_use_extended_lookup','extended lookup','checkbox to toggle usage of extended lookup config','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_use'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'ind_add_null','NULL selection','add/allow nulls to lookup drop down','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_allow'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'datatype','DB column', 'of column', null, null, 'ZSD_datatype'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'metatype','UI column','of column', 'ZPD_typeX', null, 'ZSD_datatype'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'ind_nullable','Column is nullable','of column','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_mark'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'column_len','column',' of column','ZPD_smallNBR2', null, 'ZSD_length'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'ind_is_autoseq','autosequence','auot','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_mark'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'ind_is_volatile','volatile','auot','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoff'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'ind_is_required','required','auot','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoff'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'ind_is_read_only','read only','auot','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoff'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'ind_is_hidden','hidden','auot','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoff'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'ind_editable_hidden','hidden editable','auot','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoff'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'colvalue_default','Column','of column use in DB formatter class', 'ZPD_defaultvalue', null, 'ZSD_defaultvalue'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'domain_id_physical','physical','that defines physical attributes','ZPD_domain', null, 'ZSD_domain'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'domain_id_logical','logical','that defines logical attributes','ZPD_domain', null, 'ZSD_domain'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'domain_id_semantic','semantic','that defines semantic attributes','ZPD_domain', null, 'ZSD_domain'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'column_title_ui','Column - Suffix','column to be appended to the domain title setting','ZPD_columntitle', null, 'ZSD_title'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'column_heading_ui','Column - Suffix','column to be appended to the domain heading setting','ZPD_columnheading', 'ZLD_largeblock', 'ZSD_heading'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'colpos_form','Column Axis','value of columnindex in a display grid','ZPD_smallNBR2', null, 'ZSD_formposition'),
(mdLookup_SysMDObject('et_catalog_object_column_prop'),'rowpos_form','Row Axis','value of rowindex in a display grid','ZPD_smallNBR2', null, 'ZSD_formposition'),

--
(mdLookup_SysMDObject('et_catalog_object_instance'),'catalog_id',null,'for which an instance is defined','ZPD_catalogID',null,'ZSD_catalogID'),
(mdLookup_SysMDObject('et_catalog_object_instance'),'instance_name',null,'to be defined. An Instance is a specific representation of a catalog object in display properties and filter','ZPD_instance', null, 'ZSD_instance'),
(mdLookup_SysMDObject('et_catalog_object_instance'),'description','Instance','of the catalog object (table, view). Used for lookup','ZPD_description', 'ZLD_description', 'ZSD_description'),
(mdLookup_SysMDObject('et_catalog_object_instance'),'ind_active',null,null, 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_active'),
(mdLookup_SysMDObject('et_catalog_object_instance'),'projection_list','Columnlist','list of columns used in SQL generation','ZPD_commandstring','ZLD_commandblock','ZSD_sqlclause'),
(mdLookup_SysMDObject('et_catalog_object_instance'),'ind_active_projection_list','Columnlist','mark to activate usage of column list', 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_use'),
(mdLookup_SysMDObject('et_catalog_object_instance'),'read_only_list','Read only','to set to read only','ZPD_commandstring','ZLD_commandblock','ZSD_columnlist'),
(mdLookup_SysMDObject('et_catalog_object_instance'),'ind_active_read_only_list','Read Only','of read only list', 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_use'),
(mdLookup_SysMDObject('et_catalog_object_instance'),'objectfilter','for Filter (where)','Where conditions - without WHERE clause keyword','ZPD_commandstring','ZLD_commandblock','ZSD_sqlclause'),
(mdLookup_SysMDObject('et_catalog_object_instance'),'ind_active_objectfilter','Filter','of filter clause', 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_use'),
(mdLookup_SysMDObject('et_catalog_object_instance'),'objectjoin','for Join','join conditions - with JOIN clause keyword','ZPD_commandstring','ZLD_commandblock','ZSD_sqlclause'),
(mdLookup_SysMDObject('et_catalog_object_instance'),'ind_active_objectjoin','Join','mark to activate usage of join condition', 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_use'),
(mdLookup_SysMDObject('et_catalog_object_instance'),'objectunion','for Union','union conditions - without UNION clause keyword','ZPD_commandstring','ZLD_commandblock','ZSD_sqlclause'),
(mdLookup_SysMDObject('et_catalog_object_instance'),'ind_active_objectunion','Union','mark to activate usage of union clause', 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_use'),
(mdLookup_SysMDObject('et_catalog_object_instance'),'objectgroupby','for Group by','group by clause - without keyword','ZPD_commandstring','ZLD_commandblock','ZSD_sqlclause'),
(mdLookup_SysMDObject('et_catalog_object_instance'),'ind_active_objectgroupby','Group by','mark to activate usage of group by clause', 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_use'),
(mdLookup_SysMDObject('et_catalog_object_instance'),'objectorder','for Order by','order by clause - without keyword','ZPD_commandstring','ZLD_commandblock','ZSD_sqlclause'),
(mdLookup_SysMDObject('et_catalog_object_instance'),'ind_active_objectorder','Order by','mark to activate usage of order by clause', 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_use'),
(mdLookup_SysMDObject('et_catalog_object_instance'),'ind_use_as_lookup','Lookup','this instance as lookup', 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_useas'),
(mdLookup_SysMDObject('et_catalog_object_instance'),'ind_use_as_filter','Filter','this instance as filter table in advanced filter setting', 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_useas'),
(mdLookup_SysMDObject('et_catalog_object_instance'),'ind_use_as_grid','Grid','this instance as standard grid','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_useas'),
(mdLookup_SysMDObject('et_catalog_object_instance'),'ind_use_as_detail','Detail','this instance as detail in master detail','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_useas'),
--
(mdLookup_SysMDObject('et_connection'),'conn_name',null, 'to be configured','ZPD_connection', null, 'ZSD_connection'),
(mdLookup_SysMDObject('et_connection'),'description','Connection','of connection', 'ZPD_description', 'ZLD_description', 'ZSD_description'),
(mdLookup_SysMDObject('et_connection'),'conn_name_msg','Messages','where message table is located','ZPD_connection', null, 'ZSD_DBconnection'),
(mdLookup_SysMDObject('et_connection'),'conn_type',null,null,'ZPD_typeN', null, 'ZSD_connectiontype'),
--
(mdLookup_SysMDObject('et_constraint'),'constraint_name',null,'name of a value check. Value checks are applied during editing a table','ZPD_constraintID',null,'ZSD_constraint'),
(mdLookup_SysMDObject('et_constraint'),'description',null,'of constraint. Used for display/lookup','ZPD_description', 'ZLD_description', 'ZSD_description'),
(mdLookup_SysMDObject('et_constraint'),'ind_active',null,'constraint definition','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_active'),
(mdLookup_SysMDObject('et_constraint'),'operand_1','Operand 1','Operand 1 for data check - Value that is checked with operator against the column where this constraint will be assigned',null,null,null),
(mdLookup_SysMDObject('et_constraint'),'operand_2','Operand 2','Operand 2 for data check - Value that is checked with operator against the column where this constraint will be assigned',null,null,null),
(mdLookup_SysMDObject('et_constraint'),'column_type','Column<br>datatype','Basis datatype of the column - used for some internal constraint - e.g. numeric checks',null,null,null),
(mdLookup_SysMDObject('et_constraint'),'operation','Operation','Operation used for the constraint value check',null,null,null),
--
(mdLookup_SysMDObject('et_format_collection_column'),'collection_id',null,'on which properties are configured','ZPD_collection',null,'ZSD_collection'),
(mdLookup_SysMDObject('et_format_collection_column'),'column_name',null,'on which properties are configured','ZPD_columnname',null,'ZSD_columnname'),
(mdLookup_SysMDObject('et_format_collection_column'),'ind_active',null,null, 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_active'),
(mdLookup_SysMDObject('et_format_collection_column'),'colvalue_default','Column','of column use in DB formatter class', 'ZPD_defaultvalue', null, 'ZSD_defaultvalue'),
(mdLookup_SysMDObject('et_format_collection_column'),'column_title_ui','Column','column to be appended to the domain title setting','ZPD_columntitle', null, 'ZSD_title'),
(mdLookup_SysMDObject('et_format_collection_column'),'column_heading_ui','Column','column to be appended to the domain heading setting','ZPD_columnheading', 'ZLD_largeblock', 'ZSD_heading'),
--
(mdLookup_SysMDObject('et_format_domain_logical'),'domain_id_logical','Logical','that defines logical attributes','ZPD_domain', null, 'ZSD_domain'),
(mdLookup_SysMDObject('et_format_domain_logical'),'description','Logical Domain','Used for display/lookup','ZPD_description', 'ZLD_description', 'ZSD_description'),
(mdLookup_SysMDObject('et_format_domain_logical'),'edittype',null,'of the generated edit form column','ZPD_edittype', null, 'ZSD_edittype'),
(mdLookup_SysMDObject('et_format_domain_logical'),'param_edittype','Edittype','column to be appended to the domain heading setting','ZPD_paramlong','ZLD_wideblock','ZSD_configvalue'),
(mdLookup_SysMDObject('et_format_domain_logical'),'textarea_rows','Rows','column to be appended to the domain heading setting','ZPD_smallNBR2', null, 'ZSD_editsize'),
(mdLookup_SysMDObject('et_format_domain_logical'),'textarea_cols','Columns','column to be appended to the domain heading setting','ZPD_smallNBR2', null, 'ZSD_editsize'),
--
(mdLookup_SysMDObject('et_format_domain_physical'),'domain_id_physical','Physical','that defines physical attributes','ZPD_domain', null, 'ZSD_domain'),
(mdLookup_SysMDObject('et_format_domain_physical'),'description','Pysical Domain','Used for display/lookup','ZPD_description', 'ZLD_description', 'ZSD_description'),
(mdLookup_SysMDObject('et_format_domain_physical'),'editsize','on screen','of the generated edit form column','ZPD_smallNBR3', null, 'ZSD_editsize'),
(mdLookup_SysMDObject('et_format_domain_physical'),'editmaxlength','to enter','column to be appended to the domain heading setting','ZPD_smallNBR5', null, 'ZSD_editsize'),
--
(mdLookup_SysMDObject('et_format_domain_semantic'),'domain_id_semantic','Semantic','that defines semantic/textual attributes','ZPD_domain', null, 'ZSD_domain'),
(mdLookup_SysMDObject('et_format_domain_semantic'),'description','Semantic Domain','Used for display/lookup','ZPD_description', 'ZLD_description', 'ZSD_description'),
(mdLookup_SysMDObject('et_format_domain_semantic'),'column_title_ui','Column','column to used as the domain title setting','ZPD_columntitle', null, 'ZSD_title'),
(mdLookup_SysMDObject('et_format_domain_semantic'),'column_heading_ui','Column','column to be used as the domain heading setting','ZPD_columnheading', 'ZLD_largeblock', 'ZSD_heading'),
(mdLookup_SysMDObject('et_format_domain_semantic'),'colvalue_default','Default','used as the default value in case of add new record','ZPD_paramlong','ZLD_wideblock','ZSD_configvalue'),
--
(mdLookup_SysMDObject('et_format_object'),'catalog_id',null,'for which extended format is valid','ZPD_catalogID',null,'ZSD_catalogID'),
(mdLookup_SysMDObject('et_format_object'),'instance_name',null,'for which extended format is valid','ZPD_instance', null, 'ZSD_instance'),
(mdLookup_SysMDObject('et_format_object'),'ind_active',null,null, 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_active'),
(mdLookup_SysMDObject('et_format_object'),'grid_caption_ui','on Screen',null, 'ZPD_caption', 'ZLD_description', 'ZSD_caption'),
(mdLookup_SysMDObject('et_format_object'),'grid_caption_suffix_ui','Suffix on Screen','suffix', 'ZPD_caption', 'ZLD_description', 'ZSD_caption'),
(mdLookup_SysMDObject('et_format_object'),'pagesize','Nbr. Records','number of records to be displayed','ZPD_smallNBR3', null, 'ZSD_editsize'),
(mdLookup_SysMDObject('et_format_object'),'form_width','Window Width','number of pixels for edit form','ZPD_smallNBR5', null, 'ZSD_editsize'),
(mdLookup_SysMDObject('et_format_object'),'ind_rownumbers','Rownumbers',null, 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoff'),
(mdLookup_SysMDObject('et_format_object'),'ind_advanced_search','advanced Search',null, 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoff'),
(mdLookup_SysMDObject('et_format_object'),'ind_multiselect','Multiselect',null, 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoff'),
--
(mdLookup_SysMDObject('et_format_object_column'),'catalog_id',null,'for which extended format is valid','ZPD_catalogID',null,'ZSD_catalogID'),
(mdLookup_SysMDObject('et_format_object_column'),'instance_name',null,'for which extended format is valid','ZPD_instance', null, 'ZSD_instance'),
(mdLookup_SysMDObject('et_format_object_column'),'column_name',null,'on which properties are configured','ZPD_columnname',null,'ZSD_columnname'),
(mdLookup_SysMDObject('et_format_object_column'),'ind_active',null,null, 'ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_active'),
(mdLookup_SysMDObject('et_format_object_column'),'ind_is_required','required','auot','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoff'),
(mdLookup_SysMDObject('et_format_object_column'),'ind_is_read_only','read only','auot','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoff'),
(mdLookup_SysMDObject('et_format_object_column'),'ind_is_hidden','hidden','auot','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoff'),
(mdLookup_SysMDObject('et_format_object_column'),'ind_editable_hidden','hidden editable','auot','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_onoff'),
(mdLookup_SysMDObject('et_format_object_column'),'colvalue_default','Column','of column use in DB formatter class', 'ZPD_defaultvalue', null, 'ZSD_defaultvalue'),
(mdLookup_SysMDObject('et_format_object_column'),'column_title_ui','Column - Suffix','column to be appended to the domain title setting','ZPD_columntitle', null, 'ZSD_title'),
(mdLookup_SysMDObject('et_format_object_column'),'column_heading_ui','Column - Suffix','column to be appended to the domain heading setting','ZPD_columnheading', 'ZLD_largeblock', 'ZSD_heading'),
(mdLookup_SysMDObject('et_format_object_column'),'colpos_form','Column Axis','value of columnindex in a display grid','ZPD_smallNBR2', null, 'ZSD_formposition'),
(mdLookup_SysMDObject('et_format_object_column'),'rowpos_form','Row Axis','value of rowindex in a display grid','ZPD_smallNBR2', null, 'ZSD_formposition'),
--
(mdLookup_SysMDObject('et_logging'),'conn_name','to be logged','for which logging should be activated.','ZPD_connection',null,'ZSD_DBconnection'),
(mdLookup_SysMDObject('et_logging'),'ind_active_logfile','Log to file','write log into file','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_active'),
(mdLookup_SysMDObject('et_logging'),'ind_active_logdb','Log to table','write log into DB table. Details for logging must be set in the callable object','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_active'),
(mdLookup_SysMDObject('et_logging'),'filename_log','Logfile','where logdata is written on server','ZPD_filename',null,'ZSD_filename'),
(mdLookup_SysMDObject('et_logging'),'callable_object','for logging','used for logging into DB table. Symbolic name of the logging SQL command or the logging stored procedure.','ZPD_callable',null,'ZSD_callable'),
--
(mdLookup_SysMDObject('et_lookup'),'lookup_name',null,'of a table reference. References / lookups are displayed as drop down list when editing a table','ZPD_lookup',null,'ZSD_lookup'),
(mdLookup_SysMDObject('et_lookup'),'description','Lookup','of lookup configuration. Used for display/lookup','ZPD_description', 'ZLD_description', 'ZSD_description'),
(mdLookup_SysMDObject('et_lookup'),'ind_active',null,'lookup defintion','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_active'),
(mdLookup_SysMDObject('et_lookup'),'catalog_id_lookup','Lookup','that is displayed for lookup. Definition of a lookup object can be done by standard object definition','ZPD_catalogID',null,'ZSD_catalogID'),
(mdLookup_SysMDObject('et_lookup'),'instance_name_lookup','Lookup','that is displayed for lookup. Definition of a lookup instance can be done by standard instance definition','ZPD_instance', null, 'ZSD_instance'),
(mdLookup_SysMDObject('et_lookup'),'lookup_type','Lookup','Lookup - can be standard lookup or cascading - for details check drop down list','ZPD_typeN',null,'ZSD_type'),
--
(mdLookup_SysMDObject('et_metadb_object'),'object',null,'that is part of meta db','ZPD_objectname','ZLD_tinyblock','ZSD_managedobject'),
(mdLookup_SysMDObject('et_metadb_object'),'description','Object','of the meta db object (table, view). Used for grid caption','ZPD_description', 'ZLD_description', 'ZSD_description'),
(mdLookup_SysMDObject('et_metadb_object'),'ind_active',null,'activate this configuration','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_active'),
(mdLookup_SysMDObject('et_metadb_object'),'er_level','Depth in Model','nesting level in data model','ZPD_checkbox', null, 'ZSD_level'),
(mdLookup_SysMDObject('et_metadb_object'),'sortorder','Import Export',' used for in import export script for deployment','ZPD_sortorder',null,'ZSD_sortorder'),
(mdLookup_SysMDObject('et_metadb_object'),'ind_deploy','Deploy','of this meta db object data','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_allow'),
(mdLookup_SysMDObject('et_metadb_object'),'objabbrev','Object','this meta db object - 5 character abbrevation',null, null, 'ZSD_codeof'),
(mdLookup_SysMDObject('et_metadb_object'),'catalog_id',null,'is the unique number in niota for the managed database object','ZPD_catalogID',null,'ZSD_catalogID'),
(mdLookup_SysMDObject('et_metadb_object'),'conn_name',null,'where object is located','ZPD_connection',null,'ZSD_connection'),
--
(mdLookup_SysMDObject('et_table_link'),'catalog_id_master','Master','where configuration starts','ZPD_catalogID',null,'ZSD_catalogID'),
(mdLookup_SysMDObject('et_table_link'),'instance_name_master','Master','where configuration starts','ZPD_instance',null,'ZSD_instance'),
(mdLookup_SysMDObject('et_table_link'),'logical_link','Master-Details','Catalog object instance where configuration starts','ZPD_loglink',null,'ZSD_loglink'),
(mdLookup_SysMDObject('et_table_link'),'catalog_id_detail','Detail','config is linked to','ZPD_catalogID',null,'ZSD_catalogID'),
(mdLookup_SysMDObject('et_table_link'),'instance_name_detail','Detail','that is a config to master','ZPD_instance',null,'ZSD_instance'),
(mdLookup_SysMDObject('et_table_link'),'linktype','Link','logical link - master-detail or data-advanced filter','ZPD_typeN',null,'ZSD_type'),
(mdLookup_SysMDObject('et_table_link'),'ind_logical_link_default','as default','to set a advanced filter configuration as default filter','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_active'),
(mdLookup_SysMDObject('et_table_link'),'grid_location_detail','Detail<br>grid location','Location in case of master detail where grid is on screen','ZPD_digit',null,'ZDS_gridlocation'),
(mdLookup_SysMDObject('et_table_link'),'icon_link','Master-Detail link','that contains the icon for this configuration','ZPD_filename',null,'ZSD_iconfile'),
(mdLookup_SysMDObject('et_table_link'),'description','of Relationship','of link configuration. Used for tooltip - mouse over on icon','ZPD_description', 'ZLD_description', 'ZSD_description'),
--
(mdLookup_SysMDObject('et_table_link_detail'),'catalog_id_master','Master','where configuration starts','ZPD_catalogID',null,'ZSD_catalogID'),
(mdLookup_SysMDObject('et_table_link_detail'),'instance_name_master','Master','where configuration starts','ZPD_instance',null,'ZSD_instance'),
(mdLookup_SysMDObject('et_table_link_detail'),'logical_link','Master-Details','Catalog object instance where configuration starts','ZPD_loglink',null,'ZSD_loglink'),
(mdLookup_SysMDObject('et_table_link_detail'),'column_name_master','of Master Table','used to link between master-detail/data filter instances','ZPD_columnname',null,'ZSD_columnname'),
(mdLookup_SysMDObject('et_table_link_detail'),'column_name_detail','in Detail Table','used to link between master-detail/data filter instances','ZPD_columnname',null,'ZSD_columnname'),
(mdLookup_SysMDObject('et_table_link_detail'),'operation','Operator','Comparison operation  - compare/filter Operation',null,null,null),
(mdLookup_SysMDObject('et_table_link_detail'),'sortorder','Sortorder','Sort order - used for generation order by clause in case of advance filter',null,null,null),
--
(mdLookup_SysMDObject('et_transaction'),'transaction_code',null,'Name of the transaction - group of predefined properties of a catalog object (table/view).','ZPD_transaction',null,'ZSD_transaction'),
(mdLookup_SysMDObject('et_transaction'),'description','Transaction','of the transaction','ZPD_description', 'ZLD_description', 'ZSD_description'),
(mdLookup_SysMDObject('et_transaction'),'ind_active',null,'transaction definition','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_active'),
(mdLookup_SysMDObject('et_transaction'),'targetpage','Targetpage','Target page for the transaction for user interaction',null,null,null),
(mdLookup_SysMDObject('et_transaction'),'param_set','Parameter<br>Group','Parametergroup to configure this transaction',null,null,null),
--
(mdLookup_SysMDObject('et_transaction_access'),'transaction_code',null,'on which access should be granted','ZPD_transaction',null,'ZSD_transaction'),
(mdLookup_SysMDObject('et_transaction_access'),'usergroupname','Access','to which access should be granted to use this transaction','ZPD_usergroup',null,'ZSD_usergroup'),
(mdLookup_SysMDObject('et_transaction_access'),'ind_active','use','access grants for this usergroup / transaction','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_allow'),
--
(mdLookup_SysMDObject('et_transaction_menu'),'menu_id',null,'Unique ID of the entry in the menu tree. Other menu items can refer to this as a parent menu id.' ,'ZPD_menu',null,'ZSD_menu'),
(mdLookup_SysMDObject('et_transaction_menu'),'transaction_code',null,'assigned to this menu entry','ZPD_transaction',null,'ZSD_transaction'),
(mdLookup_SysMDObject('et_transaction_menu'),'menu_label','Menu Item','to display','ZPD_label',null,'ZSD_label'),
(mdLookup_SysMDObject('et_transaction_menu'),'description','Menu Item','of menu entry - not displayed','ZPD_description', 'ZLD_description', 'ZSD_description'),
(mdLookup_SysMDObject('et_transaction_menu'),'ind_active',null,'menu configuration','ZPD_checkbox', 'ZLD_checkbox10', 'ZSD_active'),
(mdLookup_SysMDObject('et_transaction_menu'),'menu_id_parent','Parent','of the parent entry','ZPD_menu',null,'ZSD_menu'),
(mdLookup_SysMDObject('et_transaction_menu'),'icon_menu','Menue Item','that contains the icon for this configuration','ZPD_filename',null,'ZSD_iconfile'),
(mdLookup_SysMDObject('et_transaction_menu'),'sortorder','Display','display when multiple menu items under one nodes','ZPD_sortorder',null,'ZSD_sortorder'),
--
(mdLookup_SysMDObject('et_transaction_parameter_set'),'transaction_code',null,'for which this set of parameters is valid','ZPD_transaction',null,'ZSD_transaction'),
(mdLookup_SysMDObject('et_transaction_parameter_set'),'param_set','Parameter<br>Group','Name / Code of the transaction for which this set of parameters is valid',null,null,null),
(mdLookup_SysMDObject('et_transaction_parameter_set'),'param_name','Parameter<br>Name','Parametername - logical name of the configuration parameter - predefine list',null,null,null),
(mdLookup_SysMDObject('et_transaction_parameter_set'),'param_value','Parameter<br>Value','Parametervalue - value of the configuration parameter',null,null,null),
--
(mdLookup_SysMDObject('et_user'),'username',null,'of user in niota application','ZPD_userID',null,'ZSD_User'),
(mdLookup_SysMDObject('et_user'),'description','User','of user - used for lookup','ZPD_description', 'ZLD_description', 'ZSD_description'),
(mdLookup_SysMDObject('et_user'),'ind_active',null,'user configuration','ZPD_checkbox', 'ZLD_checkbox10','ZSD_active'),
(mdLookup_SysMDObject('et_user'),'password','niota','for native niota sign-in','ZPD_password',null,'ZSD_password'),
(mdLookup_SysMDObject('et_user'),'email',null,'of user - used in a lot of backend procedures - should be provided','ZPD_email',null,'ZSD_email'),
(mdLookup_SysMDObject('et_user'),'firstname',null,'of user','ZPD_humanname','ZLD_tinyblock','ZSD_firstname'),
(mdLookup_SysMDObject('et_user'),'lastname',null,'of user','ZPD_humanname','ZLD_tinyblock','ZSD_lastname'),
(mdLookup_SysMDObject('et_user'),'phone','Phone','Phonenumber of user','ZPD_phone',null,'ZSD_phone'),
(mdLookup_SysMDObject('et_user'),'ind_active_ldap','LDAP authentication','LDAP authentification - if configured correctly','ZPD_checkbox', 'ZLD_checkbox10','ZSD_onoff'),
(mdLookup_SysMDObject('et_user'),'username_ldap','LDAP','in LDAP system if used and different from main user ID','ZPD_userID',null,'ZSD_user'),
(mdLookup_SysMDObject('et_user'),'ind_is_admin','Administrator','administrator features for this user','ZPD_checkbox', 'ZLD_checkbox10','ZSD_onoff'),
(mdLookup_SysMDObject('et_user'),'lang_grid','Grid Area','for grid edit pages','ZPD_language',null,'ZSD_language'),
--
(mdLookup_SysMDObject('et_user_comm_area'),'username',null,'this communication area is valid for','ZPD_userID',null,'ZSD_User'),
(mdLookup_SysMDObject('et_user_comm_area'),'appcode',null,'this communication area is valid for','ZPD_application',null,'ZSD_application'),
(mdLookup_SysMDObject('et_user_comm_area'),'id_session','Comm. Area Entry','that generated the last comm. area entry','ZPD_session',null,'ZSD_session'),
(mdLookup_SysMDObject('et_user_comm_area'),'guid_msg','Message','last message in communication entry','ZPD_GUID',null,'ZSD_GUID'),
(mdLookup_SysMDObject('et_user_comm_area'),'lang_grid',null,'for communication area values','ZPD_language',null,'ZSD_language'),
(mdLookup_SysMDObject('et_user_comm_area'),'uca','User Communication<br>Area','Communication area data - set on last usage of UCA','ZPD_ucastring','ZLD_largeblock','ZSD_uca'),
--
(mdLookup_SysMDObject('et_user_group'),'usergroupname',null,'technical name of usergroup. A usergroup is a unit of different users. Usergroups must not be nested','ZPD_usergroup',null,'ZSD_usergroup'),
(mdLookup_SysMDObject('et_user_group'),'description','User Group','of user group - used for lookup','ZPD_description', 'ZLD_tinylock', 'ZSD_description'),
(mdLookup_SysMDObject('et_user_group'),'ind_active',null,'user group configuration','ZPD_checkbox', 'ZLD_checkbox10','ZSD_active'),
(mdLookup_SysMDObject('et_user_group'),'usergroup_type','User Group','of the user group - systemgroup, own (single-)user group, configurable group','ZPD_typeN',null,'ZSD_typeN'),
--
(mdLookup_SysMDObject('et_user_group_member'),'usergroupname',null,'to add a member. Usergroups must not be nested','ZPD_usergroup',null,'ZSD_usergroup'),
(mdLookup_SysMDObject('et_user_group_member'),'username',null,'to grant membership','ZPD_userID',null,'ZSD_User'),
(mdLookup_SysMDObject('et_user_group_member'),'description','Membership','of users membership in this group - used for lookup','ZPD_description', 'ZLD_tinylock', 'ZSD_description'),
(mdLookup_SysMDObject('et_user_group_member'),'ind_active','Membership','membership of this user in this user group','ZPD_checkbox', 'ZLD_checkbox10','ZSD_active'),
--
(mdLookup_SysMDObject('et_user_parameter'),'param_id','User System Param.','of system parameter - set by system','ZPD_bigNBR11',null,'ZSD_autosequence'),
(mdLookup_SysMDObject('et_user_parameter'),'username',null,'this parameter is valid for','ZPD_userID',null,'ZSD_User'),
(mdLookup_SysMDObject('et_user_parameter'),'param_name','User System Param.','of user system parameter - set by system','ZPD_paramlong','ZLD_wideblock','ZSD_config'),
(mdLookup_SysMDObject('et_user_parameter'),'param_value','User Parameter','user system parameter - set by system during editing a table. May be changed. Caution!','ZPD_paramlong','ZLD_wideblock','ZSD_configvalue'),
(mdLookup_SysMDObject('et_user_parameter'),'param_filter_01','01','- first filter-/assignmentcriteria for this parameter value','ZPD_paramlong','ZLD_wideblock','ZSD_textfilter'),
(mdLookup_SysMDObject('et_user_parameter'),'param_filter_02','02','- second filter-/assignmentcriteria for this parameter value','ZPD_paramlong','ZLD_wideblock','ZSD_textfilter'),
(mdLookup_SysMDObject('et_user_parameter'),'param_filter_03','03','- third filter-/assignmentcriteria for this parameter value','ZPD_paramlong','ZLD_wideblock','ZSD_textfilter'),
(mdLookup_SysMDObject('et_user_parameter'),'param_filter_04','04','- fourth filter-/assignmentcriteria for this parameter value','ZPD_paramlong','ZLD_wideblock','ZSD_textfilter'),
(mdLookup_SysMDObject('et_user_parameter'),'param_filter_05','05','- fifth filter-/assignmentcriteria for this parameter value','ZPD_paramlong','ZLD_wideblock','ZSD_textfilter'),
--
(mdLookup_SysMDObject('etx_catalog_object_config'),'appcode_cfg',null,'for which this system configuration entry is valid for','ZPD_application',null,'ZSD_application'),
(mdLookup_SysMDObject('etx_catalog_object_config'),'catalog_id',null,'for which a config value should be configured','ZPD_catalogID',null,'ZSD_catalogID'),
(mdLookup_SysMDObject('etx_catalog_object_config'),'cfg_id','Object Level','of catalog object level configuration setting','ZPD_config',null,'ZSD_config'),
(mdLookup_SysMDObject('etx_catalog_object_config'),'cfg_value','Object ID Level','of catalog object level configuration setting','ZPD_configvalue',null,'ZSD_configvalue'),
(mdLookup_SysMDObject('etx_catalog_object_config'),'description','System Config.','of this system configuration entry','ZPD_description', 'ZLD_description', 'ZSD_description'),
--
(mdLookup_SysMDObject('etx_message_text'),'appcode_msg',null,'for which this message configuration entry is valid for','ZPD_application',null,'ZSD_application'),
(mdLookup_SysMDObject('etx_message_text'),'msg_id',null,'of this message config entry','ZPD_messageID',null,'ZSD_messageID'),
(mdLookup_SysMDObject('etx_message_text'),'lang_msg','Message','of this message config entry','ZPD_language',null,'ZSD_language'),
(mdLookup_SysMDObject('etx_message_text'),'type_msg','Message','of this specific message ERR/INF/WRN ','ZPD_typeXXX',null,'ZSD_typeXXX'),
(mdLookup_SysMDObject('etx_message_text'),'ind_stop_msg','Stop Message','property that stopps execution when message is triggered','ZPD_checkbox', 'ZLD_checkbox10','ZSD_onoff'),
(mdLookup_SysMDObject('etx_message_text'),'text_msg','Message','this specifice message','ZPD_messagestring','ZLD_mediumblock','ZSD_text'),
--
(mdLookup_SysMDObject('etx_sequence'),'appcode_seq',null,'for which this sequence configuration entry is valid for','ZPD_application',null,'ZSD_application'),
(mdLookup_SysMDObject('etx_sequence'),'seq_id','Sequence<br>ID','Unique ID for this sequence definition','ZPD_config',null,null),
(mdLookup_SysMDObject('etx_sequence'),'seq_value_increment','Increment','by which the sequence is incremented in case an element is used','ZPD_smallNBR5',null,'ZSD_numeric'),
(mdLookup_SysMDObject('etx_sequence'),'seq_value_min','Start of Sequence','Minimum value/start value for this sequence definition','ZPD_bigNBR11',null,'ZSD_numeric'),
(mdLookup_SysMDObject('etx_sequence'),'seq_value_max','End of Sequence','Maximum value/end value for this sequence definition','ZPD_bigNBR11',null,'ZSD_numeric'),
(mdLookup_SysMDObject('etx_sequence'),'seq_value_cur','Current of Sequence','Current value for this sequence definition','ZPD_bigNBR11',null,'ZSD_numeric'),
(mdLookup_SysMDObject('etx_sequence'),'ind_cycle','cycle','sequence definition to cyclyc','ZPD_checkbox', 'ZLD_checkbox10','ZSD_onoff'),
--
(mdLookup_SysMDObject('etx_system_config'),'appcode_cfg',null,'for which this system configuration entry is valid for','ZPD_application',null,'ZSD_application'),
(mdLookup_SysMDObject('etx_system_config'),'cfg_id','System Level','of system level configuration setting','ZPD_config',null,'ZSD_config'),
(mdLookup_SysMDObject('etx_system_config'),'cfg_value','System Level','of system level configuration setting','ZPD_configvalue',null,'ZSD_configvalue'),
(mdLookup_SysMDObject('etx_system_config'),'description','System Config.','of this system configuration entry','ZPD_description', 'ZLD_description', 'ZSD_description'),
--
(mdLookup_SysMDObject('etx_user_config'),'appcode_cfg',null,'for which this configuration entry is valid for','ZPD_application',null,'ZSD_application'),
(mdLookup_SysMDObject('etx_user_config'),'username',null,'for which this configuration entry is valid for','ZPD_userID',null,'ZSD_User'),
(mdLookup_SysMDObject('etx_user_config'),'cfg_id','User Level','of user level configuration setting','ZPD_config',null,'ZSD_config'),
(mdLookup_SysMDObject('etx_user_config'),'cfg_value','User Level','of user level configuration setting','ZPD_configvalue',null,'ZSD_configvalue'),
(mdLookup_SysMDObject('etx_user_config'),'description','User Config.','of this user configuration entry','ZPD_description', 'ZLD_description', 'ZSD_description')
--
as loadval
on DUPLICATE KEY UPDATE
 column_title_ui = loadval.column_title_ui
,column_heading_ui = loadval.column_heading_ui
,domain_id_physical = loadval.domain_id_physical
,domain_id_logical = loadval.domain_id_logical
,domain_id_semantic = loadval.domain_id_semantic
;

--
--
update et_catalog_object_column_prop
   set ind_is_required 	= 1
 where catalog_id < 1 and ((ordinal_position_pkey is not null and ordinal_position_pkey > 0) or column_name = 'ind_active');

update et_catalog_object_column_prop
   set colvalue_default  	= 1
 where catalog_id < 1 and column_name = 'ind_active';
--
--
--
-- et_callable_access
--
update et_catalog_object_column_prop cp
   set ind_is_required 		= case when column_name in ('description', 'ind_active', 'callobject_type', 'conn_name', 'command') then 1 else ind_is_required end
      ,ind_is_hidden 		= case when column_name not in ('callable_object', 'description', 'ind_active', 'callobject_category')  then 1 else 0 end
      ,ind_editable_hidden 	= case when column_name not in ('callable_object', 'description', 'ind_active', 'callobject_category')  then 1 else 0 end
      ,colvalue_default 	= case when column_name in ('command')  then 'enter call command for ...' else colvalue_default end
 where cp.catalog_id = mdLookup_SysMDObject('et_callable_object') 
;
--
update et_catalog_object_column_prop cp
   set ind_is_required 		= case when column_name in ('catalog_id', 'conn_name', 'object', 'description', 'ind_active') then 1 else ind_is_required end
      ,ind_is_read_only 	= case when column_name in ('ind_nolog_upload', 'sort_id') then 1 else 0 end
      ,ind_is_hidden 		= case when column_name in ('sort_id', 'format_file_prefix', 'username_owner', 'usergroupname_deputy', 'ind_nolog_upload') or column_name like 'ind_cust%'  then 1 else 0 end
      ,ind_editable_hidden 	= case when column_name in ('sort_id', 'format_file_prefix', 'username_owner', 'usergroupname_deputy', 'ind_nolog_upload') or column_name like 'ind_cust%' then 1 else 0 end
      ,colvalue_default 	= case when column_name in ('description')  then 'enter physical name' else colvalue_default end
 where cp.catalog_id = mdLookup_SysMDObject('et_catalog_object') 
;
--
update et_catalog_object_column_prop cp
   set ind_is_required 		= case when column_name in ('description') then 1 else ind_is_required end
      ,ind_is_hidden 		= case when column_name not in ('catalog_id', 'instance_name', 'description', 'ind_active') then 1 else 0 end
      ,ind_editable_hidden 	= case when column_name not in ('catalog_id', 'instance_name', 'description', 'ind_active') then 1 else 0 end
      ,colvalue_default 	= case when column_name in ('description')  then 'enter description' else colvalue_default end
 where cp.catalog_id = mdLookup_SysMDObject('et_catalog_object_instance') 
;

update et_catalog_object_column_prop cp
   set ind_is_required = case when column_name in ('conn_name', 'description', 'conn_type') then 1 else ind_is_required end
where cp.catalog_id = mdLookup_SysMDObject('et_connection') 
;

update et_catalog_object_column_prop cp
   set ind_is_required = case when column_name in ('description', 'operand_1', 'column_type', 'operation') then 1 else ind_is_required end
where cp.catalog_id = mdLookup_SysMDObject('et_constraint') 
;

update et_catalog_object_column_prop cp
   set ind_is_required 		= case when column_name in ('conn_name', 'ind_active_logfile', 'ind_active_logdb', 'callable_object') then 1 else ind_is_required end
	  ,ind_is_hidden 		= case when column_name in ('callable_object', 'filename_log') then 1 else 0 end
	  ,ind_editable_hidden 	= case when column_name in ('callable_object', 'filename_log') then 1 else 0 end
	  ,colvalue_default 	= case when column_name = 'filename_log'       then 'log_useraction.log' 
								   when column_name = 'ind_active_logfile' then 0
                                   when column_name = 'ind_active_logdb' then 1
                                   else colvalue_default end
 where cp.catalog_id = mdLookup_SysMDObject('et_logging') 
; 

update et_catalog_object_column_prop cp
   set ind_is_required 		= case when column_name in ('column_title_ui', 'column_heading_ui') then 1 else ind_is_required end
	  ,ind_is_hidden 		= case when column_name in ('colvalue_default', 'column_heading_ui') then 1 else 0 end
      ,ind_editable_hidden 	= case when column_name in ('colvalue_default', 'column_heading_ui') then 1 else 0 end
 where cp.catalog_id = mdLookup_SysMDObject('et_format_collection_column') 
; 

update et_catalog_object_column_prop cp
   set ind_is_required 		= case when column_name in ('description', 'edittype') then 1 else ind_is_required end
      ,ind_is_hidden 		= case when column_name in ('param_edittype', 'textarea_rows', 'textarea_cols') then 1 else 0 end
      ,ind_editable_hidden 	= case when column_name in ('param_edittype', 'textarea_rows', 'textarea_cols') then 1 else 0 end
 where cp.catalog_id = mdLookup_SysMDObject('et_format_domain_logical') 
; 

update et_catalog_object_column_prop cp
   set ind_is_required 		= case when column_name in ('description', 'editsize', 'editmaxlength') then 1 else ind_is_required end
      ,ind_is_hidden 		= case when column_name in ('editsize', 'editmaxlength') then 1 else 0 end
      ,ind_editable_hidden 	= case when column_name in ('editsize', 'editmaxlength') then 1 else 0 end
 where cp.catalog_id = mdLookup_SysMDObject('et_format_domain_physical') 
; 

update et_catalog_object_column_prop cp
   set ind_is_required 		= case when column_name in ('description', 'column_title_ui', 'column_heading_ui') then 1 else ind_is_required end
      ,ind_is_hidden 		= case when column_name in ('column_title_ui', 'column_heading_ui', 'colvalue_default') then 1 else 0 end
      ,ind_editable_hidden 	= case when column_name in ('column_title_ui', 'column_heading_ui', 'colvalue_default') then 1 else 0 end
 where cp.catalog_id = mdLookup_SysMDObject('et_format_domain_semantic') 
; 
--
update et_catalog_object_column_prop cp
   set ind_is_required 		= case when column_name in ('description', 'lookup_type') then 1 else ind_is_required end
      ,ind_is_hidden 		= case when column_name in ('catalog_id_lookup', 'instance_name_lookup') then 1 else ind_is_hidden end
      ,ind_editable_hidden 	= case when column_name in ('catalog_id_lookup', 'instance_name_lookup') then 0 else ind_editable_hidden end
 where cp.catalog_id = mdLookup_SysMDObject('et_lookup') 
;
--
update et_catalog_object_column_prop cp
   set ind_is_required 		= case when column_name in ('description', 'er_level', 'sortorder', 'ind_deploy', 'objabbrev', 'catalog_id', 'conn_name') then 1 else ind_is_required end
 where cp.catalog_id = mdLookup_SysMDObject('et_metadb_object') 
;

update et_catalog_object_column_prop cp
   set ind_is_required 		= case when column_name in ('linktype') then 1 else ind_is_required end
      ,ind_is_hidden 		= case when column_name in ('logical_link', 'linktype', 'ind_logical_link_default', 'grid_location_detail', 'icon_link') then 1 else ind_is_hidden end
      ,ind_editable_hidden 	= case when column_name in ('logical_link', 'linktype', 'ind_logical_link_default', 'grid_location_detail', 'icon_link') then 1 else ind_editable_hidden end
 where cp.catalog_id = mdLookup_SysMDObject('et_table_link') 
;
update et_catalog_object_column_prop cp
   set ind_is_required 		= case when column_name in ('column_name_detail') then 1 else ind_is_required end
where cp.catalog_id = mdLookup_SysMDObject('et_table_link_detail') 
;

update et_catalog_object_column_prop cp
   set ind_is_required 		= case when column_name in ('description', 'ind_active', 'targetpage', 'param_set') then 1 else ind_is_required end
 where cp.catalog_id = mdLookup_SysMDObject('et_transaction') 
;

update et_catalog_object_column_prop cp
   set ind_is_required 		= case when column_name in ('transaction_code', 'menu_label', 'description', 'menue_id_parent', 'sortorder') then 1 else ind_is_required end
 where cp.catalog_id = mdLookup_SysMDObject('et_transaction_menu') 
;

update et_catalog_object_column_prop cp
   set ind_is_required 		= case when column_name in ('param_value') then 1 else ind_is_required end
 where cp.catalog_id = mdLookup_SysMDObject('et_transaction_parameter_set') 
;

update et_catalog_object_column_prop cp
   set ind_is_required 		= case when column_name in ('type_msg', 'ind_stop_msg', 'text_msg') then 1 else ind_is_required end
 where cp.catalog_id = mdLookup_SysMDObject('etx_message_text') 
;

update et_catalog_object_column_prop cp
   set ind_is_required 		= case when column_name in ('seq_value_increment', 'seq_value_min', 'seq_value_max', 'seq_value_cur', 'ind_cycle') then 1 else ind_is_required end
 where cp.catalog_id = mdLookup_SysMDObject('etx_sequence') 
;

update et_catalog_object_column_prop cp
   set ind_is_required 		= case when column_name in ('cfg_value', 'description') then 1 else ind_is_required end
 where cp.catalog_id = mdLookup_SysMDObject('etx_system_config') 
;
-- add all admin object for special formats - used in admin pages
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2023.02.10   rre     create this cool feature
--
-- *******************************************************************************
-- 
update 
-- select myvalues.* from
et_catalog_object_column_prop cp 
inner join 
 (
 select
 column_0 as catalog_id,
 column_1 as column_name, 
 column_2 as rowpos_form,
 column_3 as colpos_form 
 from
( 
values
--
ROW (mdLookup_SysMDObject('et_catalog_object'),'sort_id',					1,1),
ROW (mdLookup_SysMDObject('et_catalog_object'),'catalog_id',				2,1),
ROW (mdLookup_SysMDObject('et_catalog_object'),'conn_name',					3,1),
ROW (mdLookup_SysMDObject('et_catalog_object'),'object',					4,1),
ROW (mdLookup_SysMDObject('et_catalog_object'),'description',				5,2),
ROW (mdLookup_SysMDObject('et_catalog_object'),'ind_active',				6,1),
ROW (mdLookup_SysMDObject('et_catalog_object'),'date_activation',			6,2),
ROW (mdLookup_SysMDObject('et_catalog_object'),'objectcategory',			7,1),
ROW (mdLookup_SysMDObject('et_catalog_object'),'format_file_prefix',		7,2),
ROW (mdLookup_SysMDObject('et_catalog_object'),'username_owner',			8,1),
ROW (mdLookup_SysMDObject('et_catalog_object'),'usergroupname_deputy',		8,2),
ROW (mdLookup_SysMDObject('et_catalog_object'),'ind_nolog_upload',			9,1),
ROW (mdLookup_SysMDObject('et_catalog_object'),'ind_cust_01',				10,1),
ROW (mdLookup_SysMDObject('et_catalog_object'),'ind_cust_02',				10,2),
ROW (mdLookup_SysMDObject('et_catalog_object'),'ind_cust_03',				11,1),
ROW (mdLookup_SysMDObject('et_catalog_object'),'ind_cust_04',				11,2),
ROW (mdLookup_SysMDObject('et_catalog_object'),'ind_cust_05',				12,1),
ROW (mdLookup_SysMDObject('et_catalog_object'),'ind_cust_06',				12,2),
ROW (mdLookup_SysMDObject('et_catalog_object'),'ind_cust_07',				13,1),
ROW (mdLookup_SysMDObject('et_catalog_object'),'ind_cust_08',				13,2),
ROW (mdLookup_SysMDObject('et_catalog_object'),'ind_cust_09',				14,1),
ROW (mdLookup_SysMDObject('et_catalog_object'),'ind_cust_10',				14,2),
--
ROW (mdLookup_SysMDObject('et_catalog_object_instance'),'catalog_id',					1,1),
ROW (mdLookup_SysMDObject('et_catalog_object_instance'),'instance_name',				2,1),
ROW (mdLookup_SysMDObject('et_catalog_object_instance'),'description',					3,1),
ROW (mdLookup_SysMDObject('et_catalog_object_instance'),'ind_active',					4,1),
ROW (mdLookup_SysMDObject('et_catalog_object_instance'),'projection_list',				5,1),
ROW (mdLookup_SysMDObject('et_catalog_object_instance'),'ind_active_projection_list',	5,2),
ROW (mdLookup_SysMDObject('et_catalog_object_instance'),'projection_list',				6,1),
ROW (mdLookup_SysMDObject('et_catalog_object_instance'),'ind_active_projection_list',	6,2),
ROW (mdLookup_SysMDObject('et_catalog_object_instance'),'read_only_list',				7,1),
ROW (mdLookup_SysMDObject('et_catalog_object_instance'),'ind_active_read_only_list',	7,2),
ROW (mdLookup_SysMDObject('et_catalog_object_instance'),'objectfilter',					8,1),
ROW (mdLookup_SysMDObject('et_catalog_object_instance'),'ind_active_objectfilter',		8,2),
ROW (mdLookup_SysMDObject('et_catalog_object_instance'),'objectjoin',					9,1),
ROW (mdLookup_SysMDObject('et_catalog_object_instance'),'ind_active_objectjoin',		9,2),
ROW (mdLookup_SysMDObject('et_catalog_object_instance'),'objectunion',					10,1),
ROW (mdLookup_SysMDObject('et_catalog_object_instance'),'ind_active_objectunion',		10,2),
ROW (mdLookup_SysMDObject('et_catalog_object_instance'),'objectgroupby',				11,1),
ROW (mdLookup_SysMDObject('et_catalog_object_instance'),'ind_active_objectgroupby',		11,2),
ROW (mdLookup_SysMDObject('et_catalog_object_instance'),'objectorder',					12,1),
ROW (mdLookup_SysMDObject('et_catalog_object_instance'),'ind_active_objectorder',		12,2),

ROW (mdLookup_SysMDObject('et_catalog_object_column_prop'),'catalog_id',				1,1),
ROW (mdLookup_SysMDObject('et_catalog_object_column_prop'),'column_name',				2,1),
ROW (mdLookup_SysMDObject('et_catalog_object_column_prop'),'description',				2,2),
ROW (mdLookup_SysMDObject('et_catalog_object_column_prop'),'ind_active',				3,1),
ROW (mdLookup_SysMDObject('et_catalog_object_column_prop'),'lookup_name',				4,1),
ROW (mdLookup_SysMDObject('et_catalog_object_column_prop'),'ind_lookup_import_check',	4,2),
ROW (mdLookup_SysMDObject('et_catalog_object_column_prop'),'constraint_name',			5,1),
ROW (mdLookup_SysMDObject('et_catalog_object_column_prop'),'ind_constraint_import_check',	5,2),
ROW (mdLookup_SysMDObject('et_catalog_object_column_prop'),'ordinal_position_pkey',		6,1),
ROW (mdLookup_SysMDObject('et_catalog_object_column_prop'),'lookup_name_extended',		7,1),
ROW (mdLookup_SysMDObject('et_catalog_object_column_prop'),'column_name_extended_lookup',	7,2),
ROW (mdLookup_SysMDObject('et_catalog_object_column_prop'),'ind_use_extended_lookup',	7,3),
ROW (mdLookup_SysMDObject('et_catalog_object_column_prop'),'ind_add_null',				9,1),
ROW (mdLookup_SysMDObject('et_catalog_object_column_prop'),'datatype',					10,1),
ROW (mdLookup_SysMDObject('et_catalog_object_column_prop'),'metatype',					10,2),
ROW (mdLookup_SysMDObject('et_catalog_object_column_prop'),'ind_nullable',				10,3),
ROW (mdLookup_SysMDObject('et_catalog_object_column_prop'),'column_len',					11,1),
ROW (mdLookup_SysMDObject('et_catalog_object_column_prop'),'ind_is_autoseq',				11,2),
ROW (mdLookup_SysMDObject('et_catalog_object_column_prop'),'ind_is_volatile',				11,3),
ROW (mdLookup_SysMDObject('et_catalog_object_column_prop'),'ind_is_required',				12,1),
ROW (mdLookup_SysMDObject('et_catalog_object_column_prop'),'ind_is_read_only',			12,2),
ROW (mdLookup_SysMDObject('et_catalog_object_column_prop'),'ind_is_hidden',				13,1),
ROW (mdLookup_SysMDObject('et_catalog_object_column_prop'),'ind_editable_hidden',			13,2),
ROW (mdLookup_SysMDObject('et_catalog_object_column_prop'),'colvalue_default',			14,1),
ROW (mdLookup_SysMDObject('et_catalog_object_column_prop'),'domain_id_physical',			15,1),
ROW (mdLookup_SysMDObject('et_catalog_object_column_prop'),'domain_id_logical',			15,2),
ROW (mdLookup_SysMDObject('et_catalog_object_column_prop'),'domain_id_semantic',			15,3),
ROW (mdLookup_SysMDObject('et_catalog_object_column_prop'),'column_title_ui',				16,1),
ROW (mdLookup_SysMDObject('et_catalog_object_column_prop'),'column_heading_ui',			17,1),
ROW (mdLookup_SysMDObject('et_catalog_object_column_prop'),'colpos_form',					18,1),
ROW (mdLookup_SysMDObject('et_catalog_object_column_prop'),'rowpos_form',					18,2)
) vals
) myvalues
 on myvalues.catalog_id = cp.catalog_id
and myvalues.column_name = cp.column_name
set 
 cp.colpos_form = myvalues.colpos_form
,cp.rowpos_form = myvalues.rowpos_form
;
--
--
-- add all admin object for special formats - used in admin pages
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2023.02.10   rre     create this cool feature
--
-- *******************************************************************************

-- update et_catalog_object_column_prop set rowpos_form = null, colpos_form = null where catalog_id = -1014;
-- 
insert into et_format_object_column (catalog_id, instance_name, column_name, rowpos_form, colpos_form)
values 
(mdLookup_SysMDObject('et_catalog_object_column_prop'), 	'*ADMIN_EDIT_MDD', 	'catalog_id', 1, 1), 
(mdLookup_SysMDObject('et_catalog_object_column_prop'), 	'*ADMIN_EDIT_MDD',  'column_name', 2, 1), 
(mdLookup_SysMDObject('et_catalog_object_column_prop'), 	'*ADMIN_EDIT_MDD', 	'description', 2, 2),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), 	'*ADMIN_EDIT_MDD', 	'ind_active', 3, 1),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), 	'*ADMIN_EDIT_MDD', 	'lookup_name', 4, 1),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), 	'*ADMIN_EDIT_MDD', 	'ind_lookup_import_check', 4, 2),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), 	'*ADMIN_EDIT_MDD', 	'constraint_name', 5, 1),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), 	'*ADMIN_EDIT_MDD', 	'ind_constraint_import_check', 5, 2),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), 	'*ADMIN_EDIT_MDD', 	'ordinal_position_pkey', 6, 1),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), 	'*ADMIN_EDIT_MDD', 	'lookup_name_extended', 7, 1),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), 	'*ADMIN_EDIT_MDD', 	'column_name_extended_lookup', 7, 2),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), 	'*ADMIN_EDIT_MDD', 	'ind_use_extended_lookup', 8, 1),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), 	'*ADMIN_EDIT_MDD', 	'ind_add_null', 8, 2),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), 	'*ADMIN_EDIT_MDD', 	'datatype', 9, 1),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), 	'*ADMIN_EDIT_MDD', 	'metatype', 9, 2),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), 	'*ADMIN_EDIT_MDD', 	'ind_nullable', 10, 1),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), 	'*ADMIN_EDIT_MDD', 	'column_len', 10, 2),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), 	'*ADMIN_EDIT_MDD', 	'ind_is_autoseq', 11, 1),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), 	'*ADMIN_EDIT_MDD', 	'ind_is_volatile', 12, 1),
--
(mdLookup_SysMDObject('et_catalog_object_column_prop'), 	'*ADMIN_EDIT_MDD2', 'catalog_id', 1, 1), 
(mdLookup_SysMDObject('et_catalog_object_column_prop'), 	'*ADMIN_EDIT_MDD2', 'column_name', 2, 1), 
(mdLookup_SysMDObject('et_catalog_object_column_prop'), 	'*ADMIN_EDIT_MDD2', 'description', 2, 2),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), 	'*ADMIN_EDIT_MDD2', 'ind_active', 3, 1),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), 	'*ADMIN_EDIT_MDD2', 'column_title_ui', 4, 1),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), 	'*ADMIN_EDIT_MDD2', 'column_heading_ui', 4, 2),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), 	'*ADMIN_EDIT_MDD2', 'ind_is_required', 5, 1),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), 	'*ADMIN_EDIT_MDD2', 'ind_is_read_only', 6, 1),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), 	'*ADMIN_EDIT_MDD2', 'ind_is_hidden', 7, 1),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), 	'*ADMIN_EDIT_MDD2', 'ind_editable_hidden', 8, 1),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), 	'*ADMIN_EDIT_MDD2', 'colvalue_default', 9, 1),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), 	'*ADMIN_EDIT_MDD2', 'domain_id_physical', 10, 1),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), 	'*ADMIN_EDIT_MDD2', 'domain_id_logical', 10, 2),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), 	'*ADMIN_EDIT_MDD2', 'domain_id_semantic', 11, 1),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), 	'*ADMIN_EDIT_MDD2', 'rowpos_form', 12, 1),
(mdLookup_SysMDObject('et_catalog_object_column_prop'), 	'*ADMIN_EDIT_MDD2', 'colpos_form', 12, 2)
--
as loadval
on DUPLICATE KEY UPDATE
   rowpos_form = loadval.rowpos_form,
   colpos_form = loadval.colpos_form
; 
 